
#include"BaseUI.h"
#include"BUIRadioButton.h"

BUIRadioButton::BUIRadioButton()
{
	SetText(L"BUIRadioButton");
	SetSize(100,30);
	SetPosition(0,0);
	SetStyle(BS_RADIOBUTTON|WS_CHILD|WS_CLIPSIBLINGS);
	SetExStyle(WS_EX_WINDOWEDGE);
	checked=false;
}

BUIRadioButton::~BUIRadioButton()
{
}

bool BUIRadioButton::IsChecked()
{
	if(compHWND)
	{
		if(SendMessage(compHWND,BM_GETCHECK,0,0)==BST_CHECKED)
		{
			checked=true;
			return true;
		}else
		{
			checked=false;
			return false;
		}
	}else
	{
		return checked;
	}
}

void BUIRadioButton::SetCheckedState(bool state)
{
	checked=state;

	if(compHWND)
		SendMessage(compHWND,BM_SETCHECK,checked,0);

}

bool BUIRadioButton::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"BUTTON",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!
		SendMessage(compHWND,BM_SETCHECK,checked,0);
		EnableWindow(compHWND,compEnabled);
		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}