
#include"BUIMenu.h"

BUIMenu::BUIMenu(bool isPopup)
{
	this->isPopup=isPopup;

	if(isPopup)
		hMenu=CreatePopupMenu();
	else
		hMenu=CreateMenu();

}

HMENU BUIMenu::GetHandle()
{
	return hMenu;
}

void BUIMenu::AddSeparator(UINT id)
{
	MENUITEMINFO mii;
	ZeroMemory(&mii, sizeof(mii));

	mii.cbSize=sizeof(MENUITEMINFO);
	mii.fMask=MIIM_TYPE|MIIM_ID;
	mii.fType=MFT_SEPARATOR;
	mii.wID=id;
	InsertMenuItem(hMenu,id,FALSE,&mii);

}

void BUIMenu::AddItem(wchar_t* text,int size,UINT id)
{
	MENUITEMINFO mii;
	ZeroMemory(&mii, sizeof(mii));

	mii.cbSize=sizeof(MENUITEMINFO);
	mii.fMask=MIIM_TYPE|MIIM_ID;
	mii.fType=MFT_STRING;
	mii.wID=id;
	mii.dwTypeData=text;
	mii.cch=size;

	InsertMenuItem(hMenu,id,FALSE,&mii);
}

void BUIMenu::EnableItem(UINT id,bool enable)
{
	MENUITEMINFO mii;
	ZeroMemory(&mii, sizeof(mii));

	mii.cbSize=sizeof(MENUITEMINFO);
	mii.fMask=MIIM_STATE|MIIM_ID;
	mii.wID=id;
	mii.fState=enable?MFS_ENABLED:MFS_DISABLED;

	SetMenuItemInfo(hMenu,id,FALSE,&mii);
}

void BUIMenu::CheckItem(UINT id,bool check)
{
	MENUITEMINFO mii;
	ZeroMemory(&mii, sizeof(mii));

	mii.cbSize=sizeof(MENUITEMINFO);
	mii.fMask=MIIM_STATE|MIIM_ID;
	mii.wID=id;
	mii.fState=check?MFS_CHECKED:MFS_UNCHECKED;

	SetMenuItemInfo(hMenu,id,FALSE,&mii);
}

void BUIMenu::AddMenu(wchar_t* text,int size,BUIMenu* menu)
{
	MENUITEMINFO mii;
	ZeroMemory(&mii, sizeof(mii));

	mii.cbSize=sizeof(MENUITEMINFO);
	mii.fMask=MIIM_TYPE|MIIM_SUBMENU|MIIM_ID;
	mii.fType=MFT_STRING;
	mii.dwTypeData=text;
	mii.cch=size;
	mii.hSubMenu=menu->GetHandle();

	InsertMenuItem(hMenu,0,FALSE,&mii);
}

void BUIMenu::PopUpMenu(HWND window)
{
	if(isPopup)
	{
		POINT p;
		GetCursorPos(&p);
		TrackPopupMenu(hMenu, TPM_LEFTBUTTON, p.x, p.y, 0, window, NULL);
	}
}

void BUIMenu::AddToWindow(HWND hwnd)
{
	if(!isPopup)
		SetMenu(hwnd,hMenu);
}

BUIMenu::~BUIMenu()
{
	DestroyMenu(hMenu);
}
