
#include"BaseUI.h"
#include"BUIMLEditBox.h"

wchar_t* BUIMLEditBox::GetText() // use "ReadText" instead of "GetText" method!
{
	return compText;
}

BUIMLEditBox::BUIMLEditBox(bool readOnly,bool autoScroll)
{
	SetText(L"");
	SetSize(200,100);
	SetPosition(0,0);
	SetStyle(ES_MULTILINE|WS_CHILD|WS_CLIPSIBLINGS);

	if(readOnly)
		SetStyle(GetStyle()|ES_READONLY);

	if(autoScroll)
		SetStyle(GetStyle()|ES_AUTOHSCROLL|ES_AUTOVSCROLL);
	else
		SetStyle(GetStyle()|WS_HSCROLL|WS_VSCROLL);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);
}

BUIMLEditBox::~BUIMLEditBox()
{
}

void BUIMLEditBox::ReadText(wchar_t* text,int size)
{
	if(compHWND)
	{
		GetWindowTextW(compHWND,text,size);
	}
}

bool BUIMLEditBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"EDIT",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!
		EnableWindow(compHWND,compEnabled);
		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}