
#include"BaseUI.h"
#include"BUIListBox.h"

wchar_t* BUIListBox::GetText() // this method is useless! ( but it can be use to get current item text!)
{
	return NULL;
}

void BUIListBox::SetText(wchar_t* compText)
{
}

BUIListBox::BUIListBox(bool multipleSelection,bool sort,bool vscroll)
{
	this->multipleSelection=multipleSelection;

	SetSize(200,100);
	SetPosition(0,0);
	SetStyle(LBS_NOTIFY|WS_CHILD|WS_CLIPSIBLINGS);

	if(multipleSelection)
		SetStyle(GetStyle()|LBS_MULTIPLESEL);
	if(sort)
		SetStyle(GetStyle()|LBS_SORT);
	if(vscroll)
		SetStyle(GetStyle()|WS_VSCROLL);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);
}

BUIListBox::~BUIListBox()
{
}

int BUIListBox::AddString(wchar_t* text) // you must call this method, after create the component!
{
	if(compHWND)
	{
		return (int)SendMessage(compHWND,LB_ADDSTRING,0,(LPARAM)text);
	}else
	{
		return -1;
	}
}

void BUIListBox::RemoveString(int index) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		SendMessage(compHWND,LB_DELETESTRING,index,0);
	}
}

int BUIListBox::SearchString(wchar_t* text) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=(int)SendMessage(compHWND,LB_FINDSTRING,0,(LPARAM)text);
		if(index!=LB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}
}

int BUIListBox::GetCount() // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int count=(int)SendMessage(compHWND,LB_GETCOUNT,0,0);
		if(count!=LB_ERR)
			return count;
		return -1;
	}else
	{
		return -1;
	}		
}

int BUIListBox::GetSelectedItem() // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=(int)SendMessage(compHWND,LB_GETCURSEL,0,0);
		if(index!=LB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}	
}

bool BUIListBox::GetSelectedItem(wchar_t* buffer) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=GetSelectedItem();
		if(index>=0)
		{
			SendMessage(compHWND,LB_GETTEXT,index,(LPARAM)buffer);
			return true;
		}else
		{
			return false;
		}
	}else
	{
		return false;
	}
}

int BUIListBox::GetSelectedItems(int* itemArray,int itemCountInArray) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int items=(int)SendMessage(compHWND,LB_GETSELITEMS,itemCountInArray,(LPARAM)itemArray);
		if(items!=LB_ERR)
			return items;
		return -1;
	}else
	{
		return -1;
	}
}

void BUIListBox::ClearList() // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,LB_RESETCONTENT,0,0);
	}
}

void BUIListBox::SelectItem(int index) // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,LB_SETCURSEL,index,0);
	}
}

void BUIListBox::SelectItems(int start,int end) // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,LB_SELITEMRANGE,TRUE,MAKELPARAM(start,end));
	}
}

bool BUIListBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"LISTBOX",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!

		EnableWindow(compHWND,compEnabled);

		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}