
;--------------------------------
;Include Modern UI

  !include "MUI.nsh"
  !include Library.nsh ; for lib uninstallation
;--------------------------------
;Configuration

  ;General
name "SelectX v1.0"; Name of the installer
outfile "SelectX v1.0 setup.exe" ; installer name

  ;Default installation folder
installdir "$PROGRAMFILES\SelectX"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\SelectX" ""

CRCCheck on ; check the installer is damaged
XPStyle on ; add xp manifest to installer

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "License.txt"
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "Dummy Section" SecDummy


setoutpath $INSTDIR

file "SelectX.exe"
file "SelectX.dll"

  
 ;Store installation folder
 WriteRegStr HKCU "Software\SelectX" "" $INSTDIR

 ; uninstall details
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX" "DisplayName" "SelectX v1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX" "UninstallString" "$INSTDIR\Uninstall.exe" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX" "Publisher" "Ruchira Hasaranga" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX" "DisplayVersion" "1.0" 
 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX" "HelpLink" "ruchira66@gmail.com" 


 WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Run" "SelectX" "$INSTDIR\SelectX.exe"


 CreateDirectory "$SMPROGRAMS\SelectX"
 CreateShortCut "$SMPROGRAMS\SelectX\SelectX.lnk" "$INSTDIR\SelectX.exe"


;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd


;Uninstaller Section

Section "Uninstall"


RMDir /r "$SMPROGRAMS\SelectX"
Delete "$DESKTOP\SelectX.lnk"
Delete "$INSTDIR\Uninstall.exe"

DeleteRegKey /ifempty HKCU "Software\SelectX"


DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\SelectX"

DeleteRegValue HKLM "Software\Microsoft\Windows\CurrentVersion\Run\" "SelectX"


SectionEnd

Function .onInstSuccess

	ExecShell "open" "$INSTDIR\SelectX.exe"

FunctionEnd


Function un.onUninstSuccess
	MessageBox MB_ICONEXCLAMATION "You must reboot your PC!"
 	!insertmacro UnInstallLib DLL NOTSHARED REBOOT_NOTPROTECTED $INSTDIR\SelectX.exe
	!insertmacro UnInstallLib DLL NOTSHARED REBOOT_NOTPROTECTED $INSTDIR\SelectX.dll	
FunctionEnd

