
#include <windows.h>


#include "XMPlay.h"
#include "fmod/minifmod.h"

#pragma comment(lib,"Winmm.lib")

#pragma warning( disable : 4311 )
#pragma warning( disable : 4312 )

void* xmdata=0;
static unsigned long xmlength=0;
static FMUSIC_MODULE *mod=NULL;
HGLOBAL binadr=0;

unsigned int XMPlay::memopen(char *name)
{
	MEMFILE *memfile;
	memfile = (MEMFILE *)calloc(sizeof(MEMFILE),1);
	memfile->data=xmdata;
	memfile->length=xmlength;
	memfile->pos = 0;
	return (unsigned int)memfile;
}

void XMPlay::memclose(unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;
	free(memfile);
}

int XMPlay::memread(void *buffer, int size, unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	if (memfile->pos + size >= memfile->length)
		size = memfile->length - memfile->pos;

	memcpy(buffer, (char *)memfile->data+memfile->pos, size);
	memfile->pos += size;

	return size;
}

void XMPlay::memseek(unsigned int handle, int pos, signed char mode)
{
	MEMFILE *memfile = (MEMFILE *)handle;

	if (mode == SEEK_SET) 
		memfile->pos = pos;
	else if (mode == SEEK_CUR) 
		memfile->pos += pos;
	else if (mode == SEEK_END)
		memfile->pos = memfile->length + pos;

	if (memfile->pos > memfile->length)
		memfile->pos = memfile->length;
}

int XMPlay::memtell(unsigned int handle)
{
	MEMFILE *memfile = (MEMFILE *)handle;
	return memfile->pos;
}

void XMPlay::initEngine()
{
	HRSRC hrc=FindResource(GetModuleHandle(0),L"#102",L"XM");
	binadr=LoadResource(GetModuleHandle(0),hrc);
	xmdata=LockResource(binadr);
	xmlength=SizeofResource(GetModuleHandle(0),hrc);
	FSOUND_File_SetCallbacks(memopen, memclose, memread, memseek, memtell);
	mod = FMUSIC_LoadSong("!", NULL);
}

void XMPlay::release()
{
	if(mod){
		FMUSIC_FreeSong(mod);
		mod=0;
	}
}

void XMPlay::play()
{
	if(mod)
		FMUSIC_PlaySong(mod);
}

void XMPlay::stop()
{
	if(mod)
		FMUSIC_StopSong(mod);
}