
#ifndef _BASEUI_COMPONENT_H_
#define _BASEUI_COMPONENT_H_

#include"BaseUtil.h"

class BaseUIComponent
{
protected:
	wchar_t compClassName[32];
	wchar_t* compText;
	HWND compHWND;
	HWND compParentHWND;
	DWORD compDwStyle;
	DWORD compDwExStyle;
	int compX;
	int compY;
	int compWidth;
	int compHeight;
	bool compVisible;
	bool compEnabled;

	HFONT hFont;

public:
	WNDCLASSEX wc;

	BaseUIComponent();

	virtual ~BaseUIComponent(); // deregister class here...

	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

	virtual bool CreateComponent(); // you must override this method!

	virtual void SetFont(HFONT font);

	virtual wchar_t* GetText();

	virtual void SetText(wchar_t* compText);

	virtual wchar_t* GetClassName();

	virtual void SetHWND(HWND compHWND);

	virtual HWND GetHWND();

	virtual void SetParentHWND(HWND compParentHWND);

	virtual HWND GetParentHWND();

	virtual DWORD GetStyle();

	virtual void SetStyle(DWORD compStyle);

	virtual DWORD GetExStyle();

	virtual void SetExStyle(DWORD compExStyle);

	virtual int GetX();

	virtual int GetY();

	virtual int GetWidth();

	virtual int GetHeight();

	virtual void SetSize(int compWidth,int compHeight);

	virtual void SetPosition(int compX,int compY);

	virtual void SetVisible(bool state);

	virtual bool IsVisible();

	virtual bool IsEnabled();

	virtual void SetEnabled(bool state);

	virtual void BringToFront();

	virtual void SetKeyboardFocus();

	virtual void Repaint();

};

#endif