

#include"BaseUI.h"


BaseUIComponent* BUIComponent=0;
HHOOK bui_wnd_hook;
CRITICAL_SECTION g_csBUIWnd; // guard BUIComponent!
const wchar_t* BaseUIPropText=L"BaseUI";

LRESULT CALLBACK BUICTL_CBTProc(int nCode,WPARAM wParam,LPARAM lParam)
{

	if(nCode < 0)
        return CallNextHookEx(bui_wnd_hook, nCode, wParam, lParam);

	if(nCode==HCBT_CREATEWND){	
		HWND hwnd=(HWND)wParam;
		SetProp(hwnd,BaseUIPropText,(HANDLE)BUIComponent);
		return 0;
	}

	// Call the next hook, if there is one
    return CallNextHookEx(bui_wnd_hook, nCode, wParam, lParam);

}

HWND CreateBUIControl(BaseUIComponent* comp)
{
	// we make thread safe this function!

	EnterCriticalSection(&g_csBUIWnd);

	BUIComponent=comp;

	bui_wnd_hook=SetWindowsHookEx(WH_CBT,&BUICTL_CBTProc,0,GetCurrentThreadId());

	HWND hwnd=CreateWindowEx(comp->GetExStyle(),comp->GetClassName(),comp->GetText(),comp->GetStyle(),comp->GetX(),comp->GetY(),comp->GetWidth(),comp->GetHeight(),comp->GetParentHWND(),0,getInstance(),0);

	UnhookWindowsHookEx(bui_wnd_hook);

	LeaveCriticalSection(&g_csBUIWnd);

	return hwnd;
}


LRESULT CALLBACK  GlobalWnd_Proc(HWND hwnd,UINT msg,WPARAM wparam,LPARAM lparam)
{

	BaseUIComponent* comp;

	comp=(BaseUIComponent*)GetProp(hwnd, BaseUIPropText);

	if(!comp){ // just for safe!
		return DefWindowProc( hwnd, msg, wparam, lparam );
	}

	if(!comp->GetHWND()) // window recieve msg for the first time!
		comp->SetHWND(hwnd);

	if(msg==WM_NCDESTROY){
		RemoveProp(hwnd,BaseUIPropText);
	}

	return comp->WindowProc(hwnd,msg,wparam,lparam);
}


DWORD WINAPI GlobalThread_Proc(LPVOID lpParameter)
{
	if(lpParameter==0) // for safe!
		return 0;

	BUIThread* thread=(BUIThread*)lpParameter;

	thread->Run();

	return 0;	
}

bool CreateBUIThread(BUIThread* thread)
{
	HANDLE hThread=CreateThread(NULL,NULL,GlobalThread_Proc,thread,0,NULL);
	if(hThread)
	{
		thread->SetHandle(hThread);
		return true;
	}
	return false;
}

void DoMessagePump()
{
	MSG msg;
	
	while (GetMessage(&msg, NULL, NULL, NULL)) 
	{	
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	} 
}


void InitBaseUI(HINSTANCE instance)
{
	setInstance(instance);
	InitializeCriticalSection(&g_csBUIWnd);

	INITCOMMONCONTROLSEX icx;
	icx.dwSize=sizeof(INITCOMMONCONTROLSEX);
	icx.dwICC=ICC_WIN95_CLASSES;
	InitCommonControlsEx(&icx);

}

void DeInitBaseUI()
{
	DeleteCriticalSection(&g_csBUIWnd);
}


