
#include"BaseUI.h"
#include"BUIPasswordBox.h"

wchar_t* BUIPasswordBox::GetText() // use "ReadText" instead of "GetText" method!
{
	return compText;
}

BUIPasswordBox::BUIPasswordBox()
{
	SetText(L"");
	SetSize(100,20);
	SetPosition(0,0);
	SetStyle(ES_PASSWORD|WS_CHILD|WS_CLIPSIBLINGS);
	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);
}

BUIPasswordBox::~BUIPasswordBox()
{
}

void BUIPasswordBox::ReadText(wchar_t* text,int size)
{
	if(compHWND)
	{
		GetWindowTextW(compHWND,text,size);
	}
}

bool BUIPasswordBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"EDIT",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!
		EnableWindow(compHWND,compEnabled);
		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}