
#include"BaseUI.h"
#include"BUIEditBox.h"

wchar_t* BUIEditBox::GetText() // use "ReadText" instead of "GetText" method!
{
	return compText;
}

BUIEditBox::BUIEditBox(bool readOnly)
{
	SetText(L"");
	SetSize(100,20);
	SetPosition(0,0);

	if(readOnly)
		SetStyle(ES_READONLY|WS_CHILD|WS_CLIPSIBLINGS);
	else
		SetStyle(WS_CHILD|WS_CLIPSIBLINGS);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);
}

BUIEditBox::~BUIEditBox()
{
}

void BUIEditBox::ReadText(wchar_t* text,int size)
{
	if(compHWND)
	{
		GetWindowTextW(compHWND,text,size);
	}
}

bool BUIEditBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"EDIT",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!
		EnableWindow(compHWND,compEnabled);
		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}