
#include"BaseUI.h"
#include"BUIComboBox.h"

wchar_t* BUIComboBox::GetText() // this method is useless! ( but it can be use to get current item text!)
{
	return NULL;
}

void BUIComboBox::SetText(wchar_t* compText)
{
}


BUIComboBox::BUIComboBox(bool sort)
{
	SetSize(200,100);
	SetPosition(0,0);
	SetStyle(WS_VSCROLL|CBS_DROPDOWNLIST|WS_CHILD|WS_CLIPSIBLINGS);

	if(sort)
		SetStyle(GetStyle()|CBS_SORT);

	SetExStyle(WS_EX_CLIENTEDGE|WS_EX_WINDOWEDGE);
}

BUIComboBox::~BUIComboBox()
{
}

int BUIComboBox::AddString(wchar_t* text) // you must call this method, after create the component!
{
	if(compHWND)
	{
		return (int)SendMessage(compHWND,CB_ADDSTRING,0,(LPARAM)text);
	}else
	{
		return -1;
	}
}

void BUIComboBox::RemoveString(int index) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		SendMessage(compHWND,CB_DELETESTRING,index,0);
	}
}

int BUIComboBox::SearchString(wchar_t* text) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=(int)SendMessage(compHWND,CB_FINDSTRING ,0,(LPARAM)text);
		if(index!=CB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}
}

int BUIComboBox::GetCount() // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int count=(int)SendMessage(compHWND,CB_GETCOUNT,0,0);
		if(count!=CB_ERR)
			return count;
		return -1;
	}else
	{
		return -1;
	}		
}

int BUIComboBox::GetSelectedItem() // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=(int)SendMessage(compHWND,CB_GETCURSEL,0,0);
		if(index!=CB_ERR)
			return index;
		return -1;
	}else
	{
		return -1;
	}	
}

bool BUIComboBox::GetSelectedItem(wchar_t* buffer) // you must call this method, after create the component!
{
	if(compHWND)
	{	 
		int index=GetSelectedItem();
		if(index>=0)
		{
			SendMessage(compHWND,CB_GETLBTEXT,index,(LPARAM)buffer);
			return true;
		}else
		{
			return false;
		}
	}else
	{
		return false;
	}
}


void BUIComboBox::ClearList() // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,CB_RESETCONTENT,0,0);
	}
}

void BUIComboBox::SelectItem(int index) // you must call this method, after create the component!
{
	if(compHWND)
	{
		SendMessage(compHWND,CB_SETCURSEL,index,0);
	}
}


bool BUIComboBox::CreateComponent()
{
	if(!compParentHWND) // user must specify parent handle!
		return false;

	compHWND=CreateWindowEx(GetExStyle(),L"COMBOBOX",GetText(),GetStyle(),GetX(),GetY(),GetWidth(),GetHeight(),GetParentHWND(),0,getInstance(),0);

	if(compHWND)
	{
		SendMessage(compHWND,WM_SETFONT,(WPARAM)hFont,MAKELPARAM(true, 0)); // set default font!
		EnableWindow(compHWND,compEnabled);
		if(this->IsVisible())
			this->SetVisible(true);
		return true;
	}
	return false;	
}