
#include"rfc_amalgamated.h"
#include"resource.h"

#define s_RESET 1
#define s_DECODE_OPCODE 2

class MainWindow : public KHotPluggedDialog, public KButtonListener
{
protected:
	KButton disBtn;
	KTextBox fileTxt,disTxt;
	KFile file;
	KIcon icon;
	char formatBuff[64];
	unsigned char *codeBuff;
	unsigned int FLASH_SIZE;

	unsigned short ip;
	unsigned char op; // opcode
	unsigned char d; // direction to/from register
	unsigned char w; // Word/Byte operation
	unsigned char mod, reg, rm;

	unsigned char rep;

	int startingIP;
	KString toAddStr;
public:

	void OnHotPlug()
	{
		KHotPluggedDialog::OnHotPlug(); 

		codeBuff = 0;

		disBtn.HotPlugInto(GetDlgItem(compHWND, IDC_BUTTON1));
		disBtn.SetListener(this);

		fileTxt.HotPlugInto(GetDlgItem(compHWND, IDC_EDIT1));
		disTxt.HotPlugInto(GetDlgItem(compHWND, IDC_EDIT2));

		icon.LoadFromResource(IDI_ICON1);
		SetIcon(&icon);
	}

	void OnButtonPress(KButton *button)
	{
		if (button == &disBtn)
		{
			KString fileName;
			if (KCommonDialogBox::ShowOpenFileDialog(this, L"Open File...", L"All Files (*.*)\0*.*\0", &fileName))
			{
				fileTxt.SetText(fileName);

				if (codeBuff)
					::free(codeBuff);
				codeBuff = 0;

				if (file.OpenFile(fileName, KFile::KREAD, false))
				{
					FLASH_SIZE = file.GetFileSize();
					if (FLASH_SIZE != 0)
					{
						codeBuff = (unsigned char*)file.ReadAsData();
						disTxt.SetText(KString());
						startDisassembling();
					}
					else{
						::MessageBoxW(compHWND, L"File is empty.", L"Error", MB_ICONERROR);
					}
					file.CloseFile();
				}
				else{
					::MessageBoxW(compHWND, L"Cannot open file.", L"Error", MB_ICONERROR);
				}
			}
		}
	}

	void OnClose()
	{
		if (codeBuff)
			free(codeBuff);

		KHotPluggedDialog::OnClose();
	}

	void printfe(char *text)
	{
		toAddStr = toAddStr + text;
	}

	void startDisassembling()
	{
		int state = s_RESET;
		ip = 0;
		startingIP = 0;

		while (ip < FLASH_SIZE)
		{
			if (state == s_RESET)
			{
				ip = 0;
				state = s_DECODE_OPCODE;

				toAddStr = L"";
				printfe("\r\nstarting...\r\n\r\n");
				disTxt.SetText(disTxt.GetText() + toAddStr); // print
				toAddStr = L"";
			}
			else if (state == s_DECODE_OPCODE)
			{
				op = codeBuff[ip];

				rep = 0;
				while (true) // prefixes
				{
					op = codeBuff[ip];

					if (op == 0xf3) // REP/REPE/REPZ
					{
						ip++;
						rep = 1;
					}
					else if (op == 0xf2) // REPNE/REPNZ
					{
						ip++;
						rep = 2;
					}
					else
						break;
				}

				switch (op) {

					// Register/memory  to/from  register  
				case 0x88: // MOV REG8/MEM8, REG8
				case 0x89: // MOV REG16/MEM16, REG16
				case 0x8a: // MOV REG8, REG8/MEM8
				case 0x8b: // MOV REG16, REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();
							   if (d == 0) // REG field in the second byte identifies the src reg operand
							   {
								   printfe("MOV ");
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{ // REG field in the second byte identifies the destination reg operand
								   printfe("MOV ");
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Immediate to Register/Memory
				case 0xc6: // MOV REG8/MEM8,IMMED8
				case 0xc7: // MOV REG16/MEM16,IMMED16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();
							   printfe("MOV ");
							   printRM(w, mod, rm);
							   printfe(", ");
							   printImmediate(w);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Immediate to Register
				case 0xb0: // MOV AL,IMMED8
				case 0xb1: // MOV CL,IMMED8
				case 0xb2: // MOV DL,IMMED8
				case 0xb3: // MOV BL,IMMED8
				case 0xb4: // MOV AH,IMMED8
				case 0xb5: // MOV CH,IMMED8
				case 0xb6: // MOV DH,IMMED8
				case 0xb7: // MOV BH,IMMED8
				case 0xb8: // MOV AX,IMMED16
				case 0xb9: // MOV CX,IMMED16
				case 0xba: // MOV DX,IMMED16
				case 0xbb: // MOV BX,IMMED16
				case 0xbc: // MOV SP,IMMED16
				case 0xbd: // MOV BP,IMMED16
				case 0xbe: // MOV SI,IMMED16
				case 0xbf: // MOV DI,IMMED16
				{
							   w = ((op >> 3) & 0x1) == 0x1 ? 1 : 0;
							   reg = op & 0x7;

							   printfe("MOV ");
							   printReg(w, reg);
							   printfe(", ");

							   ip += 1; // goto next byte
							   printImmediate(w);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Memory to/from Accumulator
				case 0xa0: // MOV AL,MEM8
				case 0xa1: // MOV AX,MEM16
				case 0xa2: // MOV MEM8,AL
				case 0xa3: // MOV MEM16,AX
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // goto next byte
							   if (d == 0) // mem to accumulator
							   {
								   printfe("MOV ");
								   printfe(w == 0 ? "AL" : "AX");
								   printfe(", ");
								   printAddress();
							   }
							   else{ // accumulator to mem
								   printfe("MOV ");
								   printAddress();
								   printfe(", ");
								   printfe(w == 0 ? "AL" : "AX");
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Register/Memory to/from Segment Register
				case 0x8c: // MOV REG16/MEM16,SEGREG
				case 0x8e: // MOV SEGREG,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   if (d == 0) // segment reg to RM
							   {
								   printfe("MOV ");
								   printRM(1, mod, rm);
								   printfe(", ");
								   printSegReg(reg);
							   }
							   else{ // RM to segment reg
								   printfe("MOV ");
								   printSegReg(reg);
								   printfe(", ");
								   printRM(1, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Push Register
				case 0x50: // PUSH AX
				case 0x51: // PUSH CX
				case 0x52: // PUSH DX
				case 0x53: // PUSH BX
				case 0x54: // PUSH SP
				case 0x55: // PUSH BP
				case 0x56: // PUSH SI
				case 0x57: // PUSH DI
				{
							   reg = op & 0x7;
							   printfe("PUSH ");
							   printReg(1, reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Push Segment Register
				case 0x06: // PUSH ES
				case 0x0e: // PUSH CS
				case 0x16: // PUSH SS
				case 0x1e: // PUSH DS
				{
							   reg = (op >> 3) & 0x7;
							   printfe("PUSH ");
							   printSegReg(reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Pop Register
				case 0x58: // POP AX
				case 0x59: // POP CX
				case 0x5a: // POP DX
				case 0x5b: // POP BX
				case 0x5c: // POP SP
				case 0x5d: // POP BP
				case 0x5e: // POP SI
				case 0x5f: // POP DI
				{
							   reg = op & 0x7;
							   printfe("POP ");
							   printReg(1, reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Pop Segment Register
				case 0x07: // POP ES
				case 0x0f: // POP CS
				case 0x17: // POP SS
				case 0x1f: // POP DS
				{
							   reg = (op >> 3) & 0x7;
							   printfe("POP ");
							   printSegReg(reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// XCHG Register/Memory with Register
				case 0x86: // XCHG REG8,REG8/MEM8
				case 0x87: // XCHG REG16,REG16/MEM16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // decode next byte
							   decode();

							   printfe("XCHG ");
							   printReg(w, reg);
							   printfe(", ");
							   printRM(w, mod, rm);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// XCHG Register with Accumulator
				case 0x91: // XCHG AX,CX
				case 0x92: // XCHG AX,DX
				case 0x93: // XCHG AX,BX
				case 0x94: // XCHG AX,SP
				case 0x95: // XCHG AX,BP
				case 0x96: // XCHG AX,SI
				case 0x97: // XCHG AX,DI
				{
							   reg = op & 0x7;

							   printfe("XCHG AX, ");
							   printReg(1, reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// XLAT
				case 0xd7:
				{
							 printfe("XLAT");

							 ip += 1; // goto next byte
							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// IN Fixed Port
				case 0xe4: // IN AL,IMMED8
				case 0xe5: // IN AX,IMMED8
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   if (w == 0) // IN AL,IMMED8
								   printfe("IN AL, ");
							   else
								   printfe("IN AX, "); // IN AX,IMMED8

							   printImmediate(0);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// IN Variable Port
				case 0xec: // IN AL,DX
				case 0xed: // IN AX,DX
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0) // IN AL,DX
								   printfe("IN AL, DX");
							   else
								   printfe("IN AX, DX"); // IN AX,DX

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// OUT Fixed Port
				case 0xe6: // OUT IMMED8, AL
				case 0xe7: // OUT IMMED8, AX
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("OUT ");
							   printImmediate(0);
							   printfe(", ");

							   if (w == 0) // OUT IMMED8, AL
								   printfe("AL");
							   else
								   printfe("AX"); // OUT IMMED8, AX

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// OUT Variable Port
				case 0xee: // OUT DX, AL
				case 0xef: // OUT DX, AX
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0) // OUT DX, AL
								   printfe("OUT DX, AL");
							   else
								   printfe("OUT DX, AX"); // OUT DX, AX

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// LEA destination,source
				case 0x8d: // LEA REG16,MEM16
				{
							   ip += 1; // decode next byte
							   decode();

							   printfe("LEA ");
							   printReg(1, reg);
							   printfe(", ");
							   printEA(mod, rm);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// LDS destination,source
				case 0xc5: // LDS REG16,MEM32
				{
							   ip += 1; // decode next byte
							   decode();

							   printfe("LDS ");
							   printReg(1, reg);
							   printfe(", ");
							   printEA(mod, rm);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// LES destination,source
				case 0xc4: // LES REG16,MEM32
				{
							   ip += 1; // decode next byte
							   decode();

							   printfe("LES ");
							   printReg(1, reg);
							   printfe(", ");
							   printEA(mod, rm);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x9f: // LAHF
				{
							   printfe("LAHF");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x9e: // SAHF
				{
							   printfe("SAHF");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x9c: // PUSHF
				{
							   printfe("PUSHF");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x9d: // POPF
				{
							   printfe("POPF");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// ADD Reg./Memory and Register to Either
				case 0x00: // ADD REG8/MEM8,REG8
				case 0x01: // ADD REG16/MEM16,REG16
				case 0x02: // ADD REG8,REG8/MEM8
				case 0x03: // ADD REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("ADD ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// ADD Immediate to Accumulator
				case 0x04: // ADD AL,IMMED8
				case 0x05: // ADD AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("ADD ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// ADC Reg./Memory with Register to Either
				case 0x10: // ADC REG8/MEM8,REG8
				case 0x11: // ADC REG16/MEM16,REG16
				case 0x12: // ADC REG8,REG8/MEM8
				case 0x13: // ADC REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("ADC ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// ADC Immediate to Accumulator
				case 0x14: // ADC AL,IMMED8
				case 0X15: // ADC AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("ADC ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// INC Register
				case 0x40: // INC AX
				case 0x41: // INC CX
				case 0x42: // INC DX
				case 0x43: // INC BX
				case 0x44: // INC SP
				case 0x45: // INC BP
				case 0x46: // INC SI
				case 0x47: // INC DI
				{
							   reg = op & 0x7;

							   printfe("INC ");
							   printReg(1, reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x37: // AAA
				{
							   printfe("AAA");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x27: // DAA
				{
							   printfe("DAA");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// SUB Reg./Memory and Register to Either
				case 0x28: // SUB REG8/MEM8,REG8
				case 0x29: // SUB REG16/MEM16,REG16
				case 0x2a: // SUB REG8,REG8/MEM8
				case 0x2b: // SUB REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("SUB ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// SUB Immediate from Accumulator
				case 0x2c: // SUB AL,IMMED8
				case 0x2d: // SUB AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("SUB ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// SBB Reg./Memory with Register to Either
				case 0x18: // SBB REG8/MEM8,REG8
				case 0x19: // SBB REG16/MEM16,REG16
				case 0x1a: // SBB REG8,REG8/MEM8
				case 0x1b: // SBB REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("SBB ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// SBB Immediate to Accumulator
				case 0x1c: // SBB AL,IMMED8
				case 0X1d: // SBB AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("SBB ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// DEC Register
				case 0x48: // DEC AX
				case 0x49: // DEC CX
				case 0x4a: // DEC DX
				case 0x4b: // DEC BX
				case 0x4c: // DEC SP
				case 0x4d: // DEC BP
				case 0x4e: // DEC SI
				case 0x4f: // DEC DI
				{
							   reg = op & 0x7;

							   printfe("DEC ");
							   printReg(1, reg);

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// CMP Register/Memory and Register
				case 0x38: // CMP REG8/MEM8,REG8
				case 0x39: // CMP REG16/MEM16,REG16
				case 0x3a: // CMP REG8,REG8/MEM8
				case 0x3b: // CMP REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("CMP ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// CMP Immediate with Accumulator
				case 0x3c: // CMP AL,IMMED8
				case 0x3d: // CMP AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("CMP ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x3f: // AAS
				{
							   printfe("AAS");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x2f: // DAS
				{
							   printfe("DAS");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xd4: // AAM (takes 2 bytes)
				{
							   printfe("AAM");

							   ip += 2; // goto next 2 byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xd5: // AAD (takes 2 bytes)
				{
							   printfe("AAD");

							   ip += 2; // goto next 2 byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x98: // CBW
				{
							   printfe("CBW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x99: // CWD
				{
							   printfe("CWD");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// AND Register/Memory and Register
				case 0x20: // AND REG8/MEM8,REG8
				case 0x21: // AND REG16/MEM16,REG16
				case 0x22: // AND REG8,REG8/MEM8
				case 0x23: // AND REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("AND ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// AND Immediate to Accumulator
				case 0x24: // AND AL,IMMED8
				case 0x25: // AND AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("AND ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// OR Register/Memory and Register
				case 0x08: // OR REG8/MEM8,REG8
				case 0x09: // OR REG16/MEM16,REG16
				case 0x0a: // OR REG8,REG8/MEM8
				case 0x0b: // OR REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("OR ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// OR Immediate to Accumulator
				case 0x0c: // OR AL,IMMED8
				case 0x0d: // OR AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("OR ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// XOR Register/Memory and Register
				case 0x30: // XOR REG8/MEM8,REG8
				case 0x31: // XOR REG16/MEM16,REG16
				case 0x32: // XOR REG8,REG8/MEM8
				case 0x33: // XOR REG16,REG16/MEM16
				{
							   d = (op & 0x2) == 0x2 ? 1 : 0;
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("XOR ");
							   if (d == 0)
							   {
								   printRM(w, mod, rm);
								   printfe(", ");
								   printReg(w, reg);
							   }
							   else{
								   printReg(w, reg);
								   printfe(", ");
								   printRM(w, mod, rm);
							   }
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// XOR Immediate to Accumulator
				case 0x34: // XOR AL,IMMED8
				case 0x35: // XOR AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("XOR ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// TEST Register/Memory and Register
				case 0x84: // TEST REG8/MEM8,REG8
				case 0x85: // TEST REG16/MEM16,REG16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   ip += 1; // decode next byte
							   decode();

							   printfe("TEST ");

							   printRM(w, mod, rm);
							   printfe(", ");
							   printReg(w, reg);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// TEST Immediate and Accumulator
				case 0xa8: // TEST AL,IMMED8
				case 0xa9: // TEST AX,IMMED16
				{
							   w = (op & 0x1) == 0x1 ? 1 : 0;
							   ip += 1; // goto next byte

							   printfe("TEST ");
							   if (w == 0){
								   printfe("AL, ");
							   }
							   else{
								   printfe("AX, ");
							   }
							   printImmediate(w);
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					//====================== string functions ========================

				case 0xa4: // MOVSB 
				case 0xa5: // MOVSW
				{
							   if (rep == 1)
								   printfe("REP|REPE|REPZ ");
							   else if (rep == 2)
								   printfe("REPNE|REPNZ ");

							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0)
								   printfe("MOVSB");
							   else
								   printfe("MOVSW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xa6: // CMPSB DEST-STR8,SRC-STR8
				case 0xa7: // CMPSW DEST-STR16,SRC-STR16
				{
							   if (rep == 1)
								   printfe("REP|REPE|REPZ ");
							   else if (rep == 2)
								   printfe("REPNE|REPNZ ");

							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0)
								   printfe("CMPSB");
							   else
								   printfe("CMPSW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xae: // SCASB DEST-STR8
				case 0xaf: // SCASW DEST-STR16
				{
							   if (rep == 1)
								   printfe("REP|REPE|REPZ ");
							   else if (rep == 2)
								   printfe("REPNE|REPNZ ");

							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0)
								   printfe("SCASB");
							   else
								   printfe("SCASW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xac: // LODSB SRC-STR8
				case 0xad: // LODSW SRC-STR16
				{
							   if (rep == 1)
								   printfe("REP|REPE|REPZ ");
							   else if (rep == 2)
								   printfe("REPNE|REPNZ ");

							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0)
								   printfe("LODSB");
							   else
								   printfe("LODSW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xaa: // STOSB DEST-STR8
				case 0xab: // STOSW DEST-STR16
				{
							   if (rep == 1)
								   printfe("REP|REPE|REPZ ");
							   else if (rep == 2)
								   printfe("REPNE|REPNZ ");

							   w = (op & 0x1) == 0x1 ? 1 : 0;

							   if (w == 0)
								   printfe("STOSB");
							   else
								   printfe("STOSW");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					//=========================================================

					// CALL Direct within Segment
				case 0xe8: // CALL NEAR-PROC
				{
							   ip += 1; // goto next byte

							   printfe("CALL ");
							   printSignedValue(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// CALL Direct Intersegment
				case 0x9a: // CALL FAR-PROC
				{
							   ip += 1; // goto next byte

							   printfe("CALL IP:");
							   printImmediate(1);
							   printfe(" CS:");
							   printImmediate(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// RET Within Segment
				case 0xc3: // RET (intrasegment)
				{
							   printfe("RET");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// RET Within Seg Adding Immed to SP
				case 0xc2: // RET IMMED16 (intraseg)
				{
							   ip += 1; // goto next byte

							   printfe("RET ");
							   printImmediate(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// RET Intersegment
				case 0xcb: // RET (intersegment)
				{
							   printfe("RET");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// RET Intersegment Adding Immediate to SP
				case 0xca: // RET IMMED16 (intersegment)
				{
							   ip += 1; // goto next byte

							   printfe("RET ");
							   printImmediate(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// JMP Direct within Segment
				case 0xe9: // JMP NEAR-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JMP ");
							   printSignedValue(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// JMP Direct within Segment-Short
				case 0xeb: // JMP SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JMP ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// JMP Direct Intersegment
				case 0xea: // JMP FAR-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JMP IP:");
							   printImmediate(1);
							   printfe(" CS:");
							   printImmediate(1);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if overflow - OF=1
				case 0x70: // JO SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JO ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not overflow - OF=0
				case 0x71: // JNO SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNO ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if below/not above nor equal/carry - CF=1.
				case 0x72: // JB/JNAE/JC SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JB|JNAE ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not below/above or equal/not carry - CF=0.
				case 0x73: // JNB/JAE/JNC SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNB|JAE ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if equal/zero - ZF=1.
				case 0x74: // JE/JZ SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JE|JZ ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not equal/not zero - ZF=0.
				case 0x75: // JNE/JNZ SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNE|JNZ ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if below or equal/not above - (CF or ZF)=1.
				case 0x76: // JBE/JNA SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JBE|JNA ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not below nor equal/above - (CF or ZF)=0.
				case 0x77: // JNBE/JA SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNBE|JA ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if sign - SF=1.
				case 0x78: // JS SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JS ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not sign - SF=0.
				case 0x79: // JNS SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNS ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if parity/parity equal - PF=1.
				case 0x7a: // JP/JPE SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JP|JPE ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not parity/parity odd - PF=0.
				case 0x7b: // JNP/JPO SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNP|JPO ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if less/not greater nor equal - (SF xor OF)=1.
				case 0x7c: // JL/JNGE SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JL|JNGE ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not less/greater or equal - (SF xor OF)=0.
				case 0x7d: // JNL/JGE SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNL|JGE ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if less or equal/not greater - ((SF xor OF) or ZF)=1.
				case 0x7e: // JLE/JNG SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JLE|JNG ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// Jump if not less nor equal/greater - ((SF xor OF) or ZF)=0.
				case 0x7f: // JNLE/JG SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JNLE|JG ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xe2: // LOOP SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("LOOP ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xe1: // LOOPE/LOOPZ SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("LOOPE|LOOPZ ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xe0: // LOOPNE/LOOPNZ SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("LOOPNE|LOOPNZ ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xe3: // JCXZ SHORT-LABEL
				{
							   ip += 1; // goto next byte

							   printfe("JCXZ ");
							   printSignedValue(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xcc: // INT 3
				{
							   printfe("INT 3");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xcd: // INT IMMED8
				{
							   ip += 1; // goto next byte

							   printfe("INT ");
							   printImmediate(0);

							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xce: // INTO
				{
							   printfe("INTO");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xcf: // IRET
				{
							   printfe("IRET");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xf8: // CLC
				{
							   printfe("CLC");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xf5: // CMC
				{
							   printfe("CMC");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xf9: // STC
				{
							   printfe("STC");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xfc: // CLD
				{
							   printfe("CLD");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xfd: // STD
				{
							   printfe("STD");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xfa: // CLI
				{
							   printfe("CLI");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xfb: // STI
				{
							   printfe("STI");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0xf4: // HLT
				{
							   printfe("HLT");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x9b: // WAIT
				{
							   printfe("WAIT");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// just ignore these
				case 0xd8: // ESC 0,SOURCE
				case 0xd9: // ESC 1,SOURCE
				case 0xda: // ESC 2,SOURCE
				case 0xdb: // ESC 3,SOURCE
				case 0xdc: // ESC 4,SOURCE
				case 0xdd: // ESC 5,SOURCE
				case 0xde: // ESC 6,SOURCE
				case 0xdf: // ESC 7,SOURCE
				{
							   ip += 1; // decode next byte
							   decode();

							   if (mod == 0x1) {
								   ip += 1;
							   }
							   else if (mod == 0x2) {
								   ip += 2;
							   }
							   else if ((mod == 0x0) && (rm == 0x6))
							   {
								   ip += 2;
							   }
				}
					break;

				case 0xf0: // LOCK
				{
							   printfe("LOCK");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

				case 0x90: // NOP
				{
							   printfe("NOP");

							   ip += 1; // goto next byte
							   printfe("\r\n");
							   state = s_DECODE_OPCODE;
				}
					break;

					// ADD REG8/MEM8,IMMED8
					// OR REG8/MEM8,IMMED8
					// ADC REG8/MEM8,IMMED8
					// SBB REG8/MEM8,IMMED8
					// AND REG8/MEM8,IMMED8
					// SUB REG8/MEM8,IMMED8
					// XOR REG8/MEM8,IMMED8
					// CMP REG8/MEM8,IMMED8
				case 0x80:
					// ADD REG16/MEM16,IMMED16
					// OR REG16/MEM16,IMMED16
					// ADC REG16/MEM16,IMMED16
					// SBB REG16/MEM16,IMMED16
					// AND REG16/MEM16,IMMED16
					// SUB REG16/MEM16,IMMED16
					// XOR REG16/MEM16,IMMED16
					// CMP REG16/MEM16,IMMED16
				case 0x81:
				{
							 w = (op & 0x1) == 0x1 ? 1 : 0;

							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // ADD
							 {
								 printfe("ADD ");

							 }
							 else if (reg == 0x1) // OR
							 {
								 printfe("OR ");
							 }
							 else if (reg == 0x2) // ADC
							 {
								 printfe("ADC ");
							 }
							 else if (reg == 0x3) // SBB
							 {
								 printfe("SBB ");
							 }
							 else if (reg == 0x4) // AND
							 {
								 printfe("AND ");
							 }
							 else if (reg == 0x5) // SUB
							 {
								 printfe("SUB ");
							 }
							 else if (reg == 0x6) // XOR
							 {
								 printfe("XOR ");
							 }
							 else if (reg == 0x7) // CMP
							 {
								 printfe("CMP ");
							 }

							 printRM(w, mod, rm);
							 printfe(", ");
							 printSignedValue(w);

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// ADD REG8/MEM8,IMMED8
					// ADC REG8/MEM8,IMMED8
					// SBB REG8/MEM8,IMMED8
					// SUB REG8/MEM8,IMMED8
					// CMP REG8/MEM8,IMMED8
				case 0x82:
					// ADD REG16/MEM16,IMMED8
					// ADC REG16/MEM16,IMMED8
					// SBB REG16/MEM16,IMMED8
					// SUB REG16/MEM16,IMMED8
					// CMP REG16/MEM16,IMMED8
				case 0x83:
				{
							 w = (op & 0x1) == 0x1 ? 1 : 0;

							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // ADD
							 {
								 printfe("ADD ");

							 }
							 else if (reg == 0x2) // ADC
							 {
								 printfe("ADC ");
							 }
							 else if (reg == 0x3) // SBB
							 {
								 printfe("SBB ");
							 }
							 else if (reg == 0x5) // SUB
							 {
								 printfe("SUB ");
							 }
							 else if (reg == 0x7) // CMP
							 {
								 printfe("CMP ");
							 }

							 printRM(w, mod, rm);
							 printfe(", ");
							 printSignedValue(0); // 8bit for both opcodes!

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// POP REG16/MEM16
				case 0x8f:
				{
							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // POP
							 {
								 printfe("POP ");
								 printRM(1, mod, rm);

								 printfe("\r\n");
							 }
							 state = s_DECODE_OPCODE;
				}
					break;

					// ROL REG8/MEM8,1
					// ROR REG8/MEM8,1
					// RCL REG8/MEM8,1
					// RCR REG8/MEM8,1
					// SAL/SHL REG8/MEM8,1
					// SHR REG8/MEM8,1
					// SAR REG8/MEM8,1
				case 0xd0:
					// ROL REG16/MEM16,1
					// ROR REG16/MEM16,1
					// RCL REG16/MEM16,1
					// RCR REG16/MEM16,1
					// SAL/SHL REG16/MEM16,1
					// SHR REG16/MEM16,1
					// SAR REG16/MEM16,1
				case 0xd1:
				{
							 w = (op & 0x1) == 0x1 ? 1 : 0;

							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // ROL
							 {
								 printfe("ROL ");

							 }
							 else if (reg == 0x1) // ROR
							 {
								 printfe("ROR ");
							 }
							 else if (reg == 0x2) // RCL
							 {
								 printfe("RCL ");
							 }
							 else if (reg == 0x3) // RCR
							 {
								 printfe("RCR ");
							 }
							 else if (reg == 0x4) // SAL/SHL
							 {
								 printfe("SAL|SHL ");
							 }
							 else if (reg == 0x5) // SHR
							 {
								 printfe("SHR ");
							 }
							 else if (reg == 0x6) // SAR
							 {
								 printfe("SAR ");
							 }

							 printRM(w, mod, rm);
							 printfe(", 1");

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;

				}
					break;

					// ROL REG8/MEM8,CL
					// ROR REG8/MEM8,CL
					// RCL REG8/MEM8,CL
					// RCR REG8/MEM8,CL
					// SAL/SHL REG8/MEM8,CL
					// SHR REG8/MEM8,CL
					// SAR REG8/MEM8,CL
				case 0xd2:
					// ROL REG16/MEM16,CL
					// ROR REG16/MEM16,CL
					// RCL REG16/MEM16,CL
					// RCR REG16/MEM16,CL
					// SAL/SHL REG16/MEM16,CL
					// SHR REG16/MEM16,CL
					// SAR REG16/MEM16,CL
				case 0xd3:
				{
							 w = (op & 0x1) == 0x1 ? 1 : 0;

							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // ROL
							 {
								 printfe("ROL ");

							 }
							 else if (reg == 0x1) // ROR
							 {
								 printfe("ROR ");
							 }
							 else if (reg == 0x2) // RCL
							 {
								 printfe("RCL ");
							 }
							 else if (reg == 0x3) // RCR
							 {
								 printfe("RCR ");
							 }
							 else if (reg == 0x4) // SAL/SHL
							 {
								 printfe("SAL|SHL ");
							 }
							 else if (reg == 0x5) // SHR
							 {
								 printfe("SHR ");
							 }
							 else if (reg == 0x6) // SAR
							 {
								 printfe("SAR ");
							 }

							 printRM(w, mod, rm);
							 printfe(", CL");

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// TEST REG8/MEM8,IMMED8
					// NOT REG8/MEM8
					// NEG REG8/MEM8
					// MUL REG8/MEM8
					// IMUL REG8/MEM8
					// DIV REG8/MEM8
					// IDIV REG8/MEM8
				case 0xf6:
					// TEST REG16/MEM16,IMMED16
					// NOT REG16/MEM16
					// NEG REG16/MEM16
					// MUL REG16/MEM16
					// IMUL REG16/MEM16
					// DIV REG16/MEM16
					// IDIV REG16/MEM16
				case 0xf7:
				{
							 w = (op & 0x1) == 0x1 ? 1 : 0;

							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // TEST
							 {
								 printfe("TEST ");

							 }
							 else if (reg == 0x2) // NOT
							 {
								 printfe("NOT ");
							 }
							 else if (reg == 0x3) // NEG
							 {
								 printfe("NEG ");
							 }
							 else if (reg == 0x4) // MUL
							 {
								 printfe("MUL ");
							 }
							 else if (reg == 0x5) // IMUL
							 {
								 printfe("IMUL ");
							 }
							 else if (reg == 0x6) // DIV
							 {
								 printfe("DIV ");
							 }
							 else if (reg == 0x7) // IDIV
							 {
								 printfe("IDIV ");
							 }

							 printRM(w, mod, rm);

							 if (reg == 0x0) // for TEST command
							 {
								 printfe(", ");
								 printImmediate(w);
							 }

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// INC REG8/MEM8
					// DEC REG8/MEM8
				case 0xfe:
				{
							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // INC
							 {
								 printfe("INC ");

							 }
							 else if (reg == 0x1) // DEC
							 {
								 printfe("DEC ");
							 }

							 printRM(0, mod, rm);

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

					// INC MEM16
					// DEC MEM16
					// CALL REG16/MEM16 (intra)
					// CALL MEM16 (intersegment)
					// JMP REG16/MEM16 (intra)
					// JMP MEM16 (intersegment)
					// PUSH MEM16
				case 0xff:
				{
							 ip += 1; // decode next byte
							 decode();

							 if (reg == 0x0) // INC
							 {
								 printfe("INC ");
							 }
							 else if (reg == 0x1) // DEC
							 {
								 printfe("DEC ");
							 }
							 else if (reg == 0x2) // CALL
							 {
								 printfe("CALL ");
							 }
							 else if (reg == 0x3) // CALL
							 {
								 printfe("CALL ");
							 }
							 else if (reg == 0x4) // JMP
							 {
								 printfe("JMP ");
							 }
							 else if (reg == 0x5) // JMP
							 {
								 printfe("JMP ");
							 }
							 else if (reg == 0x6) // PUSH
							 {
								 printfe("PUSH ");
							 }

							 if ((reg == 0x02) || (reg == 0x04))
								 printRM(1, mod, rm);
							 else
								 printEA(mod, rm);

							 printfe("\r\n");
							 state = s_DECODE_OPCODE;
				}
					break;

				default:
					sprintf(formatBuff,"  %002X \t\tUNKNOWN OPCODE\r\n\r\ndone!\r\n", op);
					disTxt.SetText(disTxt.GetText() + formatBuff); // print it
					return; // exit from decoding
				}

				KString opBytes;
				int byteCount = 0;
				for (int i = startingIP; i < ip; i++) // print bytes
				{
					sprintf(formatBuff, "%002X ", codeBuff[i]);
					opBytes = opBytes + formatBuff;
					byteCount++;
				}

				// change tab count according to byte count
				KString strTabs;
				if (byteCount < 3)
					strTabs = L"\t\t";
				else if (byteCount < 6)
					strTabs = L"\t";

				disTxt.SetText(disTxt.GetText() + L"  " + opBytes + strTabs); // print byte set

				disTxt.SetText(disTxt.GetText() + toAddStr); // print disassembly
				toAddStr = L""; // clear disassembly text buffer
				startingIP = ip;
			}

		}

		toAddStr = L"";
		printfe("\r\ndone!\r\n");
		disTxt.SetText(disTxt.GetText() + toAddStr);
	}

	void decode()
	{
		mod = codeBuff[ip] >> 6;
		reg = (codeBuff[ip] >> 3) & 0x7;
		rm = codeBuff[ip] & 0x7;

		ip = ip + 1;
	}

	void printReg(unsigned char w, unsigned char reg)
	{
		if (w == 0){
			// Byte data
			switch (reg) {
			case 0: // AL
				printfe("AL"); break;
			case 1: // CL
				printfe("CL"); break;
			case 2: // DL
				printfe("DL"); break;
			case 3: // BL
				printfe("BL"); break;
			case 4: // AH
				printfe("AH"); break;
			case 5: // CH
				printfe("CH"); break;
			case 6: // DH
				printfe("DH"); break;
			case 7: // BH
				printfe("BH"); break;
			}
		}
		else{
			// Word data
			switch (reg) {
			case 0: // AX
				printfe("AX"); break;
			case 1: // CX
				printfe("CX"); break;
			case 2: // DX
				printfe("DX"); break;
			case 3: // BX
				printfe("BX"); break;
			case 4: // SP
				printfe("SP"); break;
			case 5: // BP
				printfe("BP"); break;
			case 6: // SI
				printfe("SI"); break;
			case 7: // DI
				printfe("DI"); break;
			}
		}
	}

	void printSegReg(unsigned char reg)
	{
		switch (reg) {
		case 0: // ES
			printfe("ES"); break;
		case 1: // CS
			printfe("CS"); break;
		case 2: // SS
			printfe("SS"); break;
		case 3: // DS
			printfe("DS"); break;
		}
	}

	void printImmediate(unsigned char w)
	{
		if (w == 0) // 8bit
		{
			sprintf(formatBuff,"%002Xh", (unsigned char)codeBuff[ip]);
			printfe(formatBuff);
			ip++;
		}
		else{ // 16 bit
			sprintf(formatBuff,"%00004Xh", (unsigned short)(codeBuff[ip + 1] << 8 | codeBuff[ip]));
			printfe(formatBuff);
			ip += 2;
		}
	}

	void printAddress()
	{
		sprintf(formatBuff, "[ %00004Xh ]", (unsigned short)(codeBuff[ip + 1] << 8 | codeBuff[ip]));
		printfe(formatBuff);
		ip += 2;
	}

	void printEA(unsigned char mod, unsigned char rm)
	{
		unsigned short disp = 0;
		unsigned short address = 0;

		if (mod == 0x1) {
			// 8-bit displacement follows
			disp = codeBuff[ip];
			ip += 1;
		}
		else if (mod == 0x2) {
			// 16-bit displacement follows
			disp = codeBuff[ip + 1] << 8 | codeBuff[ip];
			ip += 2;
		}
		else if ((mod == 0x0) && (rm == 0x6)) // Direct address
		{
			address = codeBuff[ip + 1] << 8 | codeBuff[ip];
			ip += 2;
		}

		switch (rm) {
		case 0: // EA = (BX) + (SI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[BX + SI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[BX + SI + %002Xh]", (unsigned char)disp);
			break;
		case 1: // EA = (BX) + (DI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[BX + DI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[BX + DI + %002Xh]", (unsigned char)disp);
			break;
		case 2: // EA = (BP) + (SI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[BP + SI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[BP + SI + %002Xh]", (unsigned char)disp);
			break;
		case 3: // EA = (BP) + (DI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[BP + DI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[BP + DI + %002Xh]", (unsigned char)disp);
			break;
		case 4: // EA = (SI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[SI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[SI + %002Xh]", (unsigned char)disp);
			break;
		case 5: // EA = (DI) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[DI + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[DI + %002Xh]", (unsigned char)disp);
			break;
		case 6:
			if (mod == 0x0) {
				// Direct address			
				sprintf(formatBuff, "[ %00004Xh ]", (unsigned short)address);
			}
			else {
				// EA = (BP) + DISP
				if (mod == 0x2)
					sprintf(formatBuff, "[BP + %00004Xh]", (unsigned short)disp);
				else
					sprintf(formatBuff, "[BP + %002Xh]", (unsigned char)disp);
			}
			break;
		case 7: // EA = (BX) + DISP
			if (mod == 0x2)
				sprintf(formatBuff, "[BX + %00004Xh]", (unsigned short)disp);
			else
				sprintf(formatBuff, "[BX + %002Xh]", (unsigned char)disp);
			break;
		}
		printfe(formatBuff);
	}

	void printRM(unsigned char w, unsigned char mod, unsigned char rm) {
		if (mod == 0x3)
			// Register-to-register mode
			printReg(w, rm);
		else
			// Memory mode
			printEA(mod, rm);
	}

	void printSignedValue(unsigned char w)
	{
		if (w == 0)
		{
			if (codeBuff[ip] >> 7 == 1) // check sign bit (if so, it's a negative value)
			{
				unsigned char value = ~codeBuff[ip]; // invert and add 1 to restore 2s complement value
				value++;
				sprintf(formatBuff, "-%hu", value);
			}
			else
			{
				sprintf(formatBuff, "+%hu", codeBuff[ip]);
			}

			ip++;
		}
		else{
			if (codeBuff[ip + 1] >> 7 == 1) // check sign bit (if so, it's a negative value)
			{
				unsigned short value = ~(codeBuff[ip + 1] << 8 | codeBuff[ip]); // invert and add 1 to restore 2s complement value
				value++;
				sprintf(formatBuff, "-%hu", value);
			}
			else
			{
				unsigned short value = (codeBuff[ip + 1] << 8 | codeBuff[ip]);
				sprintf(formatBuff, "+%hu", value);
			}

			ip += 2;
		}
		printfe(formatBuff);
	}
};

class DisassemblerApp : KApplication
{
public:
	int Main(KString **argv, int argc)
	{
		MainWindow wnd;

		::HotPlugAndRunDialogBox(IDD_DIALOG1, 0, &wnd);

		return 0;
	}
};

START_RFC_APPLICATION_NO_CMD_ARGS(DisassemblerApp)