﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net.NetworkInformation;

namespace NetMeter
{
    public partial class Form1 : Form
    {
        private NetworkInterface[] nicArr;
        private long prevReceived;
        private long prevSent;

        public Form1()
        {
            prevReceived = 0;
            prevSent = 0;

            nicArr = NetworkInterface.GetAllNetworkInterfaces();

            InitializeComponent();

            //this.Text += " - " + GetLogonSid.getLogonSid();

            if (nicArr.Length != 0)
            {
                for (int i = 0; i < nicArr.Length; i++)
                {
                    comboBox1.Items.Add(nicArr[i].Name);
                }

                comboBox1.SelectedIndex = Properties.Settings.Default.iface;

                if(Properties.Settings.Default.top==1)
                {
                    checkBox1.Checked = true;
                    this.TopMost = true;
                }

                timer1.Enabled = true;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (nicArr.Length != 0)
            {
                Properties.Settings.Default.iface = comboBox1.SelectedIndex;
                Properties.Settings.Default.Save();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
           if (nicArr.Length != 0)
           {
               // Grab NetworkInterface object that describes the current interface
               NetworkInterface nic = nicArr[comboBox1.SelectedIndex];

               // Grab the stats for that interface
               IPv4InterfaceStatistics interfaceStats = nic.GetIPv4Statistics();
             
               if (interfaceStats != null)
               {
                   label1.Text = (interfaceStats.BytesReceived/(1024*1024)).ToString() + " MB";
                   label2.Text = (interfaceStats.BytesSent / (1024 * 1024)).ToString() + " MB";

                   if (prevReceived != interfaceStats.BytesReceived)
                   {
                       label1.ForeColor = Color.Red;   
                   }else
                   {
                       label1.ForeColor = Color.Black;
                          
                   }

                   prevReceived = interfaceStats.BytesReceived;

                   if (prevSent != interfaceStats.BytesSent)
                   {
                       label2.ForeColor = Color.Red;
                   }
                   else
                   {
                       label2.ForeColor = Color.Black;

                   }

                   prevSent = interfaceStats.BytesSent;

               }else
               {
                   MessageBox.Show("Cannot get interface stats!", "Error");
               }
           }
        }

        private void label4_Click(object sender, EventArgs e)
        {

        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                Properties.Settings.Default.top = 1;
                Properties.Settings.Default.Save();
                this.TopMost = true;
            }
            else
            {
                Properties.Settings.Default.top = 0;
                Properties.Settings.Default.Save();
                this.TopMost = false;
            }
        }
    }
}
