﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Collections;


namespace Kordova
{
    public partial class NewProjectForm : Form
    {
        string projectPath;
        string androidSDKPath;

        public NewProjectForm(ArrayList targets,string projectPath,string androidSDKPath)
        {
            InitializeComponent();

            this.projectPath = projectPath;
            this.androidSDKPath = androidSDKPath;

            foreach(string target in targets)
            {
                comboBox1.Items.Add(target);
            }

            comboBox1.SelectedIndex = 0;
        }



        private void button1_Click(object sender, EventArgs e)
        {
            if (textBox1.Text.Length != 0)
            {
                if (textBox2.Text.Length != 0)
                {
                    if (textBox3.Text.Length != 0)
                    {
                        string projectName = textBox1.Text.Trim();
                        string activityName = textBox2.Text.Trim();
                        string packageName = textBox3.Text.Trim();
                        string sdkID=(comboBox1.SelectedIndex+1).ToString();
                        string toolPath = "\""+androidSDKPath+"\\tools\\android.bat\"";
                        string cmd = toolPath + " create project --target " + sdkID + " --name "+projectName+" --path \""+projectPath+"\" --activity "+activityName+" --package "+packageName;
                        Utils.RunCMDWithWait(cmd, System.IO.Path.GetTempPath());
                        this.Close();
                    }
                    else
                    {
                        MessageBox.Show("Please enter value for package name.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Please enter value for activity name.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please enter value for project name.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.Text.Length != 0)
                textBox3.Text = "com.kordova." + textBox1.Text.ToLower();
        }
    }
}
