﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;
using System.Collections;
using System.Text.RegularExpressions;

namespace Kordova
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            textBox1.Text = Properties.Settings.Default.project;
            textBox2.Text = Properties.Settings.Default.jdk;
            textBox3.Text = Properties.Settings.Default.android;
            textBox4.Text = Properties.Settings.Default.ant;
        }

        ArrayList GetTargetList(string progOutput)
        {
            ArrayList targetList = new ArrayList();
            string[] lines = progOutput.Split(new char[] { '\n' });

            if (lines.Length != 0)
            {
                foreach (string line in lines)
                {
                    if (Regex.IsMatch(line, @"id: \d+ or"))
                    {
                        string name = line.Split('\"', '\"')[1];
                        targetList.Add(name);
                    }
                }
            }

            return targetList;
        }

        string GetProgramOutput(string path, string args, string workingDir)
        {
            string strOutput = "";
            try
            {
                //Create process
                System.Diagnostics.Process pProcess = new System.Diagnostics.Process();

                //strCommand is path and file name of command to run
                pProcess.StartInfo.FileName = path;

                //strCommandParameters are parameters to pass to program
                pProcess.StartInfo.Arguments = args;

                pProcess.StartInfo.UseShellExecute = false;

                //Set output of program to be written to process output stream
                pProcess.StartInfo.RedirectStandardOutput = true;

                //Optional
                pProcess.StartInfo.WorkingDirectory = workingDir;

                //Start the process
                pProcess.Start();

                //Get program output
                strOutput = pProcess.StandardOutput.ReadToEnd();

                //Wait for process to finish
                pProcess.WaitForExit();
            }
            catch (Exception)
            { }

            return strOutput;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox2.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox3.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox4.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (!File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string output = GetProgramOutput(androidPath + "\\tools\\android.bat", "list targets", androidPath + "\\tools");
                        if (output.Length != 0)
                        {
                            ArrayList targets = GetTargetList(output);
                            if (targets.Count != 0)
                            {
                                new NewProjectForm(targets, projectPath, androidPath).ShowDialog();
                            }
                            else
                            {
                                MessageBox.Show("Error occured while reading available SDK list. Did you installed at least one SDK platform?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Error occured while reading available SDK list. Did you select the correct android SDK dir?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder already contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.project = textBox1.Text;
            Properties.Settings.Default.jdk = textBox2.Text;
            Properties.Settings.Default.android = textBox3.Text;
            Properties.Settings.Default.ant = textBox4.Text;

            Properties.Settings.Default.Save();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string output = GetProgramOutput(androidPath + "\\tools\\android.bat", "list targets", androidPath + "\\tools");
                        if (output.Length != 0)
                        {
                            ArrayList targets = GetTargetList(output);
                            if (targets.Count != 0)
                            {
                                string projectName = Utils.GetProjectName(projectPath);
                                if (projectName.Length != 0)
                                {
                                    new ChangeSDKForm(projectName, targets, projectPath, androidPath).ShowDialog();
                                }
                                else
                                {
                                    MessageBox.Show("Error occured while reading project name. Is this a valid project?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                                }
                            }
                            else
                            {
                                MessageBox.Show("Error occured while reading available SDK list. Did you installed at least one SDK platform?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Error occured while reading available SDK list. Did you select the correct android SDK dir?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder does not contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string jdkHome = textBox2.Text;
                        if (jdkHome.Length != 0)
                        {
                            string antHome = textBox4.Text;
                            if (antHome.Length != 0)
                            {
                                Utils.RunAntCommand(projectPath, androidPath, jdkHome, antHome, "ant debug", System.IO.Path.GetTempPath());
                            }
                            else
                            {
                                MessageBox.Show("Please select the Ant folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Please select the JDK HOME folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder does not contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string jdkHome = textBox2.Text;
                        if (jdkHome.Length != 0)
                        {
                            string antHome = textBox4.Text;
                            if (antHome.Length != 0)
                            {
                                Utils.RunAntCommand(projectPath, androidPath, jdkHome, antHome, "ant release", System.IO.Path.GetTempPath());
                            }
                            else
                            {
                                MessageBox.Show("Please select the Ant folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Please select the JDK HOME folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder does not contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string jdkHome = textBox2.Text;
                        if (jdkHome.Length != 0)
                        {
                            string antHome = textBox4.Text;
                            if (antHome.Length != 0)
                            {
                                Utils.RunAntCommand(projectPath, androidPath, jdkHome, antHome, "ant clean", System.IO.Path.GetTempPath());
                            }
                            else
                            {
                                MessageBox.Show("Please select the Ant folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Please select the JDK HOME folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder does not contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (!File.Exists(projectPath + "\\release.keystore"))
                {
                    string jdkHome = textBox2.Text;
                    if (jdkHome.Length != 0)
                    {
                        new GenerateKeyForm(jdkHome, projectPath).ShowDialog();
                    }
                    else
                    {
                        MessageBox.Show("Please select the JDK HOME folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected project folder already contains a keystore.\n\nTo generate another key: \n\tdelete release.keystore file\n\tdelete key entries from ant.properties file", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            string projectPath = textBox1.Text;
            if (projectPath.Length != 0)
            {
                if (File.Exists(projectPath + "\\build.xml"))
                {
                    string androidPath = textBox3.Text;
                    if (androidPath.Length != 0)
                    {
                        string projectName = Utils.GetProjectName(projectPath);
                        if(projectName.Length!=0)
                        {
                            string outputFile = projectPath + "\\bin\\" + projectName + "-release.apk";
                            if (File.Exists(outputFile))
                            {
                                string cmd = "\"" + androidPath + "\\platform-tools\\adb.exe\" install -r \"" + outputFile + "\"";
                                Utils.RunCMDWithWait(cmd, System.IO.Path.GetTempPath());
                            }
                            else
                            {
                                MessageBox.Show("Cannot find " + projectName + "-release.apk file.\n\n\tDid you forget to build(release) the project?\n\tDid you forget to generate the keystore?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Error occured while reading project name. Is this a valid project?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Please select the android sdk folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Selected folder does not contains a project.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please select a project folder.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

    }
}
