﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Xml;

namespace Kordova
{
    public class Utils
    {
        public static void RunAntCommand(string projectPath,string androidPath,string jdkHome,string antHome,string cmd, string batDirPath)
        {
            string content = "set ANDROID_SDK=" + androidPath + "\r\n";
            content += "set JAVA_HOME=" + jdkHome + "\r\n";
            content += "set path=%path%;" + androidPath + "\\tools\\"+"\r\n";
            content += "set path=%path%;" + androidPath + "\\platform-tools\\" + "\r\n";
            content += "set path=%path%;" + antHome + "\\bin\\" + "\r\n";

            content += "cd /d " + "\"" + projectPath + "\\\"\r\n";
            content += "call " + cmd + "\r\necho.\r\necho.\r\nPAUSE";

            string batFilePath=batDirPath + "\\kordova.bat";
            File.WriteAllText(batFilePath, content);
            System.Diagnostics.Process.Start(batFilePath).WaitForExit();
            File.Delete(batFilePath);
        }


        public static void RunCMDWithWait(string cmd, string batDirPath)
        {
            string batFilePath = batDirPath + "\\kordova.bat";
            File.WriteAllText(batFilePath, "echo off\r\ncall " + cmd + "\r\necho.\r\necho.\r\nPAUSE");
            System.Diagnostics.Process.Start(batFilePath).WaitForExit();
            File.Delete(batFilePath);
        }

        public static string GetProjectName(string projectPath)
        {
            string projectName = "";
            XmlTextReader reader = new XmlTextReader(projectPath+"\\build.xml");
            while (reader.Read())
            {
                if(reader.NodeType==XmlNodeType.Element)
                {
                        if(reader.Name=="project")
                        {
                            projectName=reader.GetAttribute("name");
                            break;
                        }   
                }
            }

            reader.Close();
            return projectName;
        }
    }
}
