﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kordova
{
    public partial class GenerateKeyForm : Form
    {
        string projectPath;
        string jdkHome;

        public GenerateKeyForm(string jdkHome,string projectPath)
        {
            this.projectPath = projectPath;
            this.jdkHome = jdkHome;

            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string keyAlias = textBox1.Text.Trim();
            if(keyAlias.Length!=0)
            {
                string aliasPassword = textBox2.Text.Trim();
                if (aliasPassword.Length != 0)
                {
                    if(aliasPassword.Length>=6)
                    {
                        string storePassword = textBox3.Text.Trim();
                        if (storePassword.Length != 0)
                        {
                            if(storePassword.Length>=6)
                            {
                                string cmd = "\"" + jdkHome + "\\bin\\keytool.exe\" -genkey -v -keystore \"" + projectPath + "\\release.keystore" + "\" -alias " + keyAlias + " -keyalg RSA -keysize 2048 -validity 10000 -storepass " + storePassword + " -keypass " + aliasPassword;
                                Utils.RunCMDWithWait(cmd, System.IO.Path.GetTempPath());
                                this.Close();
                                if(System.IO.File.Exists(projectPath + "\\release.keystore"))
                                {
                                    string content = "key.store=release.keystore\nkey.alias=" + keyAlias + "\nkey.store.password=" + storePassword + "\nkey.alias.password=" + aliasPassword;
                                    System.IO.File.AppendAllText(projectPath + "\\ant.properties", content);
                                    MessageBox.Show("ant.properties file successfully updated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                                }
                                else
                                {
                                    MessageBox.Show("Error occured while generating keystore.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                                }
                            }
                            else
                            {
                                MessageBox.Show("Store Password must be more than 5 digits.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show("Please enter value for Store Password.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show("Alias Password must be more than 5 digits.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show("Please enter value for Alias Password.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
            else
            {
                MessageBox.Show("Please enter value for Key Alias.", "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }
    }
}
