

#include "rfc_amalgamated.h"
#include <gdiplus.h>

using namespace Gdiplus;
#pragma comment(lib, "gdiplus.lib")

/*
#include<dwmapi.h>
#pragma comment(lib, "dwmapi.lib")

void EnableGlassEffect(HWND windowHWND)
{
	DWM_BLURBEHIND bb = { 0 };

	bb.fEnable = true;
	bb.dwFlags = DWM_BB_ENABLE|DWM_BB_TRANSITIONONMAXIMIZED;
	bb.hRgnBlur = 0;
	bb.fTransitionOnMaximized = true;

	DwmEnableBlurBehindWindow(windowHWND, &bb);
}

void ExtendClientToAll(HWND windowHWND)
{
	MARGINS margins = { -1 };
	DwmExtendFrameIntoClientArea(windowHWND, &margins);
}

bool IsDWMEnabled()
{
	BOOL ret=FALSE;
	DwmIsCompositionEnabled(&ret);
	return ret==TRUE? true:false;
}
*/

void SetWindowBlur(HWND hWnd)
{
	const HINSTANCE hModule = LoadLibraryW(L"user32.dll");
	if (hModule)
	{
		struct ACCENTPOLICY
		{
			int nAccentState;
			int nFlags;
			int nColor;
			int nAnimationId;
		};
		struct WINCOMPATTRDATA
		{
			int nAttribute;
			PVOID pData;
			ULONG ulDataSize;
		};
		typedef BOOL(WINAPI*pSetWindowCompositionAttribute)(HWND, WINCOMPATTRDATA*);
		const pSetWindowCompositionAttribute SetWindowCompositionAttribute = (pSetWindowCompositionAttribute)GetProcAddress(hModule, "SetWindowCompositionAttribute");
		if (SetWindowCompositionAttribute)
		{
			ACCENTPOLICY policy = { 3, 0, 0, 0 }; // ACCENT_ENABLE_BLURBEHIND=3...
			WINCOMPATTRDATA data = { 19, &policy, sizeof(ACCENTPOLICY) }; // WCA_ACCENT_POLICY=19
			SetWindowCompositionAttribute(hWnd, &data);
		}
		FreeLibrary(hModule);
	}
}

#define BACK_ALPHA 0
class GlassWindow : public KFrame
{
	Brush *backBrush;
	Pen *framePen;

	// client area drag data
	bool windowDraging;
	int cld_mouse_x;
	int cld_mouse_y;

public:
	GlassWindow()
	{
		windowDraging = false;

		backBrush = new SolidBrush(Color(255, BACK_ALPHA, BACK_ALPHA, BACK_ALPHA));
		framePen = new Pen(Color(50, 0, 0, 0));

		SetSize(400, 300);
		SetStyle(WS_POPUP);
		//SetExStyle(WS_EX_LAYERED);
		CreateComponent();
		//SetLayeredWindowAttributes(compHWND, RGB(255,0,255), 0, LWA_COLORKEY);
		SetWindowBlur(compHWND);
	}

	~GlassWindow()
	{
		delete backBrush;
		delete framePen;
	}

	void paintWindow(HDC hdc)
	{
		Gdiplus::Graphics graphics(hdc);

		graphics.FillRectangle(backBrush, 0, 0, compWidth, compHeight);
		graphics.DrawRectangle(framePen, 0, 0, compWidth - 1, compHeight - 1);
	}

	LRESULT OnPaint(WPARAM wParam, LPARAM lParam)
	{
		PAINTSTRUCT ps;

		HDC hdc= BeginPaint(compHWND, &ps);

		paintWindow(hdc);

		EndPaint(compHWND, &ps);

		return 0;
	}

	LRESULT OnMouseLDown(WPARAM wParam, LPARAM lParam)
	{
		windowDraging = true;
		SetCapture(compHWND);

		cld_mouse_x = LOWORD(lParam);
		cld_mouse_y = HIWORD(lParam);

		return 0;
	}

	LRESULT OnMouseMove(WPARAM wParam, LPARAM lParam)
	{
		if (windowDraging) // client area drag!
		{
			POINT pos;
			GetCursorPos(&pos);
			SetPosition(pos.x - cld_mouse_x, pos.y - cld_mouse_y);
		}
		return 0;
	}

	LRESULT OnMouseLUp(WPARAM wParam, LPARAM lParam)
	{
		if (windowDraging) // client area drag!
		{
			ReleaseCapture();
			windowDraging = false;
		}
		return 0;
	}


	LRESULT OnErase(WPARAM wParam, LPARAM lParam)
	{
		return 1;
	}

	BEGIN_KMSG_HANDLER
		ON_KMSG(WM_LBUTTONDOWN, OnMouseLDown)
		ON_KMSG(WM_MOUSEMOVE, OnMouseMove)
		ON_KMSG(WM_LBUTTONUP, OnMouseLUp)
		ON_KMSG(WM_PAINT, OnPaint)
		ON_KMSG(WM_ERASEBKGND, OnErase)
	END_KMSG_HANDLER(KFrame)
};


class MyApplication : public KApplication
{
public:
	
	void MakeWindow()
	{
		GlassWindow myWindow;

		myWindow.SetText(L"GlassUI Window");
		myWindow.CenterScreen();
		myWindow.SetVisible(true);

		::DoMessagePump(); // message loop
	}

	int Main(KString **argv, int argc)
	{

		GdiplusStartupInput gdiplusStartupInput;
		ULONG_PTR gdiplusToken;
		GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);

		MakeWindow();

		GdiplusShutdown(gdiplusToken);

		return 0;
	}
};

START_RFC_APPLICATION(MyApplication);