using System;
using System.Collections.Generic;
using System.Text;

using System.IO;
using System.Web;

namespace Giulia
{
    class Program
    {
        static int docID;

        static bool  IsIDContain(List<ItemData> dataList,string id)
        {
            bool found = false;
            for (int i = 0; i < dataList.Count; i++)
            {
                if (dataList[i].id == id)
                {
                    found = true;
                    break;
                }
            }
            return found;
        }

        static ItemData GetItemDataForID(string id, List<ItemData> dataList)
        {
            for (int i = 0; i < dataList.Count; i++)
            {
                if (dataList[i].id == id)
                {
                    return dataList[i];
                }
            }
            return null;
        }

        static void diggItemsForLevel(string indexPrologue,int rootIndex,int level, HTMDocument parentDoc, List<HTMDocument> docList,List<ItemData> dataList)
        {
            string indexStr = indexPrologue;
            indexStr += ".1";
            

            Console.WriteLine("checking for: "+indexStr);

            if (IsIDContain(dataList, indexStr))
            {

                Console.WriteLine("found: " + indexStr);
                

                // create new document & link it to parent
                HTMDocument doc = new HTMDocument();
                doc.fileName = docID + ".htm";
                docID++;
                parentDoc.itemList[rootIndex].link = doc.fileName;
                doc.backFileName = parentDoc.fileName;
                doc.title = parentDoc.itemList[rootIndex].text; // title is parent text

                for (int x = 0; x < parentDoc.levelList.Count; x++) // copy parent level list
                {
                    doc.levelList.Add(parentDoc.levelList[x]);
                }

                doc.levelList[parentDoc.levelList.Count-1]=parentDoc.fileName;
                doc.levelList.Add(null);

                docList.Add(doc);

                int i = 0;
                while (true)
                {
                    indexStr = indexPrologue;
                    indexStr += "." + (i + 1);
                    if (i != 0)
                    {
                        Console.WriteLine("checking for:" + indexStr);
                    }
                    if(IsIDContain(dataList, indexStr))
                    {
                        if (i != 0)
                        {
                            Console.WriteLine("found:" + indexStr);
                        }
                        ItemData itemData = GetItemDataForID(indexStr,dataList);
                        ItemLink itemLink = new ItemLink();
                        itemLink.text = itemData.text;
                        doc.itemList.Add(itemLink);
                        diggItemsForLevel(indexStr, i, level + 1, doc, docList, dataList);
                    }else
                    {
                        break;
                    }
                    i++;
                }

            }
        }

        static void Main(string[] args)
        {
            Console.WriteLine("Giulia v1.0 By R.Hasaranga (c) 2013\nhttp://www.hasaranga.com\n");
            if (args.Length == 0)
                return;

            StreamReader sr = new StreamReader(args[0]);
            String itemNumber="";
            String curLine;
            String curBlock="";

            List<ItemData> itemList=new List<ItemData>();

            while ((curLine = sr.ReadLine()) != null)
            {
                if (curLine.Length > 0)
                {
                    if (curLine[0] == '#')
                    {
                        if (itemNumber.Length > 0)// ignore first # encounter
                        {
                            ItemData iData=new ItemData();
                            iData.id=itemNumber;
                            iData.text=curBlock.Trim();
                            itemList.Add(iData);
                            Console.WriteLine(itemNumber+": "+curBlock.Trim());
                            curBlock = "";
                        }
                        itemNumber = curLine.Trim();
                    }
                    else
                    {
                        curBlock += curLine;
                    }
                }
            }


            docID = 1000;      

            List<HTMDocument> docList = new List<HTMDocument>();
            int i=0;

            HTMDocument rootDoc = new HTMDocument();
            rootDoc.fileName = "index.htm";
            rootDoc.levelList.Add(null);
            docID++;
            docList.Add(rootDoc);
            while (true)
            {
                string indexPrologue="#"+(i+1);
                Console.WriteLine("checking for:" + indexPrologue);
                if (IsIDContain(itemList, indexPrologue))
                {
                    Console.WriteLine("found:" + indexPrologue);

                    // setup level list
                    //doc.levelList
                    ItemData itemData = GetItemDataForID(indexPrologue, itemList);
                    ItemLink itemLink = new ItemLink();
                    itemLink.text = itemData.text;
                    rootDoc.itemList.Add(itemLink);

                    diggItemsForLevel(indexPrologue, i, 0, rootDoc, docList, itemList);
                    i++;
                }else
                {
                    break;
                }
            }


            // clear "out" dir
            Directory.Delete("out",true);
            Directory.CreateDirectory("out");

            // copy style.css
            File.Copy("style.css", "out/style.css");

            // generate html files

            for (int j = 0; j < docList.Count; j++)
                {
                    HTMDocument doc = docList[j];

                    StreamWriter sw = new StreamWriter("out/"+doc.fileName);
                    string htmCode = "<!DOCTYPE html><html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" /></head><body><div id=\"main-container\">" +
                        "<p class=\"level-index\">Level:";

                    // write levels
                    for (int k = 0; k < doc.levelList.Count; k++)
                    {
                        if (doc.levelList[k] != null)
                        {
                            htmCode += "&nbsp;&nbsp;<a href=\"" + doc.levelList[k] + "\">"+k+"</a>";
                        }
                        else
                        {
                            htmCode += "&nbsp;&nbsp;" + k;
                        }
                    }

                    htmCode += "</p>";

                    if (doc.title != null)
                    {
                        htmCode += "<p class=\"title-text\">" + HttpUtility.HtmlEncode(doc.title) + "</p>";
                    }

                    for (int k = 0; k < doc.itemList.Count; k++)
                    {
                        ItemLink itemLink = doc.itemList[k];
                        if (itemLink.link != null)
                        {
                            htmCode += "<p class=\"list-item-text-link\"><a href=\"" + itemLink.link + "\">" + (k + 1) + ".&nbsp;&nbsp;" + HttpUtility.HtmlEncode(itemLink.text) + "</a></p>";
                        }
                        else
                        {
                            htmCode += "<p class=\"list-item-text-no-link\">" + (k + 1) + ".&nbsp;&nbsp;" + HttpUtility.HtmlEncode(itemLink.text) + "</p>";
                        }
                    }

                    if (doc.backFileName != null)
                    {
                        htmCode += "<br><p class=\"back-text\"><a href=\"" + doc.backFileName + "\">Back</a></p>";
                    }

                    htmCode += "</div></body></html>";

                    sw.Write(htmCode);
                    sw.Close();
                }
           


        }
    }
}
