

#include<windows.h>
#include<tchar.h>
#include <commctrl.h>
#include"stubgen.h"

#pragma comment(lib,"Comctl32.lib")

// amalgamated version of DW UI Framework!

// to do: font support line for DWComponent!
// every string mustbe _T("") type...

class DWLookAndFeel
{
public:
	static COLORREF	COL_BTNBACKGROUND;
	static COLORREF	COL_BTNTEXT;
	static COLORREF	COL_BTNFRAME;
	static COLORREF	COL_WNDBACKGROUND;
	static COLORREF	COL_WNDBORDER;
	static COLORREF	COL_TITLEBAR_BACKGROUND;
	static COLORREF	COL_TITLEBAR_DEACTIVE_BACKGROUND;
	static COLORREF	COL_TITLEBAR_BORDER;
	static COLORREF	COL_TITLEBAR_TEXT;
	static COLORREF	COL_LBL_TEXT;
	static COLORREF	COL_CLOSE_BUTTON_FRAME;
	static COLORREF	COL_CLOSE_BUTTON_BACKGROUND;
	static COLORREF	COL_CLOSE_BUTTON_BOX;
	static COLORREF	COL_CLOSE_BUTTON_BOX_DOWN;
	static COLORREF	COL_MIN_BUTTON_BOX;
	static COLORREF	COL_MIN_BUTTON_BACKGROUND;
	static COLORREF	COL_MIN_BUTTON_BACKGROUND_DOWN;
	static COLORREF	COL_MIN_BUTTON_FRAME;
};

COLORREF DWLookAndFeel::COL_BTNBACKGROUND=PALETTERGB(147,196,255);
COLORREF DWLookAndFeel::COL_BTNTEXT=PALETTERGB(255,255,255);
COLORREF DWLookAndFeel::COL_BTNFRAME=PALETTERGB(89,164,255);
COLORREF DWLookAndFeel::COL_WNDBACKGROUND=PALETTERGB(237,245,255);
COLORREF DWLookAndFeel::COL_WNDBORDER=PALETTERGB(181,207,247);
COLORREF DWLookAndFeel::COL_TITLEBAR_BACKGROUND=PALETTERGB(147,196,255);
COLORREF DWLookAndFeel::COL_TITLEBAR_DEACTIVE_BACKGROUND=PALETTERGB(193,223,255);
COLORREF DWLookAndFeel::COL_TITLEBAR_BORDER=PALETTERGB(89,164,255);
COLORREF DWLookAndFeel::COL_TITLEBAR_TEXT=PALETTERGB(255,255,255);
COLORREF DWLookAndFeel::COL_LBL_TEXT=PALETTERGB(95,134,170);
COLORREF DWLookAndFeel::COL_CLOSE_BUTTON_FRAME=PALETTERGB(181,207,247);
COLORREF DWLookAndFeel::COL_CLOSE_BUTTON_BACKGROUND=PALETTERGB(237,245,255);
COLORREF DWLookAndFeel::COL_CLOSE_BUTTON_BOX=PALETTERGB(147,196,255);
COLORREF DWLookAndFeel::COL_CLOSE_BUTTON_BOX_DOWN=PALETTERGB(95,134,170);
COLORREF DWLookAndFeel::COL_MIN_BUTTON_BOX=PALETTERGB(147,196,255);
COLORREF DWLookAndFeel::COL_MIN_BUTTON_BACKGROUND=PALETTERGB(237,245,255);
COLORREF DWLookAndFeel::COL_MIN_BUTTON_BACKGROUND_DOWN=PALETTERGB(95,134,170);
COLORREF DWLookAndFeel::COL_MIN_BUTTON_FRAME=PALETTERGB(181,207,247);


class DWFont
{
protected:
	HFONT hFont;
public:
	DWFont()
	{
		hFont=(HFONT)GetStockObject(DEFAULT_GUI_FONT);
	}
	
	virtual HFONT getFontHandle()
	{
		return hFont;
	}

	static HFONT getSystemFontHandle()
	{
		return (HFONT)GetStockObject(SYSTEM_FONT);
	}

	virtual void setFontHandle(HFONT hFont)
	{
		this->hFont=hFont;
	}
};

class DWClassNameGenerator
{
private:
	static int classCount;

public:
	static void generateClassName(TCHAR* className)
	{
		swprintf(className,32,L"DW_%d",GetTickCount()^classCount);
		classCount++;
	}

};

class DWApplication
{
public:
	static HINSTANCE hInstance;
	static HWND hToolTipWindow;

	static void InitDWApp(HINSTANCE apphInstance)
	{
		DWApplication::hInstance=apphInstance;
		INITCOMMONCONTROLSEX icc;
		icc.dwSize=sizeof(INITCOMMONCONTROLSEX);
		icc.dwICC =ICC_WIN95_CLASSES;
		InitCommonControlsEx(&icc);


	}

	static void doMessagePump()
	{
		MSG msg;
		while( GetMessage( &msg, NULL, 0, 0 ) ) {
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	} 
};

HINSTANCE DWApplication::hInstance=0;
int DWClassNameGenerator::classCount=1;


class DWComponent
{
private:
	char* wndProcStub;
	
	LRESULT wndProc(HWND hWnd, UINT msg, WPARAM wParam,LPARAM lParam )
	{
		if(this->getHWND()==0) // just for safe!
			this->setHWND(hWnd);

		return this->windowProc(hWnd,msg,wParam,lParam);
	}

protected:
	HWND compHWND;
	HWND compParentHWND;
	TCHAR compClassName[32];
	LPCWSTR compText;
	DWORD compDwStyle;
	DWORD compDwExStyle;
	int compX;
	int compY;
	int compWidth;
	int compHeight;
	bool compVisible;
	bool compEnabled;

	DWFont* compFont;

public:
	WNDCLASSEX wc;

	DWComponent()
	{
		compHWND=0;
		compParentHWND=0;
		compText=0;
		compDwStyle=0;
		compDwExStyle=0;
		compX=CW_USEDEFAULT;
		compY=CW_USEDEFAULT;
		compWidth=CW_USEDEFAULT;
		compHeight=CW_USEDEFAULT;
		compVisible=true;
		compEnabled=true;

		DWClassNameGenerator::generateClassName(compClassName);

		wc.cbSize=sizeof(WNDCLASSEX);
		wc.hCursor=LoadCursor(NULL,IDC_ARROW);
		wc.hIcon=0;
		wc.lpszMenuName=0;
		wc.hbrBackground=(HBRUSH)GetSysColorBrush(COLOR_BTNFACE);
		wc.cbClsExtra=0;
		wc.cbWndExtra=0;
		wc.hIconSm=0;
		wc.style=0;
		wc.hInstance=DWApplication::hInstance;
		wc.lpszClassName=compClassName;

		wndProcStub=0;

		compFont=new DWFont();
	}

	~DWComponent()
	{
		UnregisterClass(compClassName,DWApplication::hInstance);
		if(wndProcStub)
			GlobalFree(wndProcStub);
		if(compFont)
			delete compFont;
	}

	virtual DWFont* getFont()
	{
		return compFont;
	}

	virtual bool createComponent()
	{			
		void* pointer;

		GET_POINTER(DWComponent::wndProc,pointer)
		wndProcStub=generateStub(this,pointer);
		wc.lpfnWndProc = (WNDPROC)wndProcStub;

		if(RegisterClassEx(&wc)==0)
			return false;

		this->setHWND(CreateWindowEx(this->getExStyle(),this->getClassName(),this->getText(),this->getStyle(),this->getX(),this->getY(),this->getWidth(),this->getHeight(),this->getParentHWND(),0,DWApplication::hInstance,0));

		if(this->getHWND())
		{
			if(this->isVisible())
				this->setVisible(true);
			return true;
		}
		return false;	
	}

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){
					case WM_SIZE:
						return this->onResize(wParam,lParam);
					case WM_PAINT:
						return this->onPaint(wParam,lParam);
					case WM_ERASEBKGND:
						return 1;
					default:
						return DefWindowProc( hWnd, msg, wParam, lParam );
		}
		return 0;
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		return 0;
	}

	virtual  LRESULT onResize(WPARAM wParam,LPARAM lParam)
	{
		compWidth=LOWORD(lParam);
		compHeight=HIWORD(lParam);

		return 0;
	}

	virtual void setHWND(HWND compHWND)
	{
		this->compHWND=compHWND;
	}

	virtual HWND getHWND()
	{
		return this->compHWND;
	}

	virtual void setParentHWND(HWND compParentHWND)
	{
		this->compParentHWND=compParentHWND;
	}

	virtual HWND getParentHWND()
	{
		return this->compParentHWND;
	}

	virtual LPCWSTR getClassName()
	{
		return this->compClassName;
	}

	virtual LPCWSTR getText()
	{
		return this->compText;
	}

	virtual void setText(LPCWSTR compText)
	{
		this->compText=compText;
		if(this->getHWND())
			SetWindowText(this->getHWND(),this->getText());
	}

	virtual DWORD getStyle()
	{
		return this->compDwStyle;
	}

	virtual void setStyle(DWORD compStyle)
	{
		this->compDwStyle=compStyle;
	}

	virtual DWORD getExStyle()
	{
		return this->compDwExStyle;
	}

	virtual void setExStyle(DWORD compExStyle)
	{
		this->compDwExStyle=compExStyle;
	}

	virtual int getX()
	{
		return this->compX;
	}

	virtual int getY()
	{
		return this->compY;
	}

	virtual int getWidth()
	{
		return this->compWidth;
	}

	virtual int getHeight()
	{
		return this->compHeight;
	}

	virtual void setSize(int compWidth,int compHeight)
	{
		this->compWidth=compWidth;
		this->compHeight=compHeight;

		if(this->getHWND())
			SetWindowPos(this->getHWND(),0,0,0,compWidth,compHeight,SWP_NOMOVE|SWP_NOREPOSITION);
	}

	virtual void setPosition(int compX,int compY)
	{
		this->compX=compX;
		this->compY=compY;

		if(this->getHWND())
			SetWindowPos(this->getHWND(),0,this->getX(),this->getY(),0,0,SWP_NOSIZE|SWP_NOREPOSITION);
	}

	virtual void setVisible(bool state)
	{
		this->compVisible=state;
		ShowWindow(this->getHWND(),state ? SW_SHOW:SW_HIDE);
	}

	virtual bool isVisible()
	{
		return this->getHWND() ? this->compVisible : false;
	}

	virtual bool isEnabled()
	{
		return this->compEnabled;
	}

	virtual void setEnabled(bool state)
	{
		this->compEnabled=state;

		if(this->getHWND())
			EnableWindow(this->getHWND(),this->compEnabled);
	}

	virtual void bringToFront()
	{
		if(this->getHWND())
			BringWindowToTop(this->getHWND());
	}

	virtual void setFocus()
	{
		if(this->getHWND())
			SetFocus(this->getHWND());
	}

	virtual void repaint()
	{
		if(this->getHWND())
		{
			InvalidateRect(this->getHWND(), NULL, FALSE);
			UpdateWindow(this->getHWND()); 
		}
	}

};


/*
class DWButton: public DWComponent
{
protected:
	COLORREF colBTNFACE;
	COLORREF colBTNFACEDOWN;
	COLORREF colBTNFRAME;

	COLORREF colCurrent;

public:
	DWButton()
	{
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(50,20);
		this->setPosition(0,0);

		colBTNFACE=DWLookAndFeel::COL_BTNFACE;
		colCurrent=DWLookAndFeel::COL_BTNFACE;
		colBTNFACEDOWN=DWLookAndFeel::COL_BTNFACEDOWN;
		colBTNFRAME=DWLookAndFeel::COL_BTNFRAME;
	}

	virtual void setColor(COLORREF buttonFace,COLORREF buttonFaceDown)
	{
		colBTNFACE=buttonFace;
		colCurrent=colBTNFACE;
		colBTNFACEDOWN=buttonFaceDown;
		this->repaint();
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hFaceBrush,hFrameBrush;

		hdc = BeginPaint(this->getHWND(), &ps);
		hFaceBrush=CreateSolidBrush(colCurrent);
		hFrameBrush=CreateSolidBrush(colBTNFRAME);

		GetClientRect(this->getHWND(),&rect);
		FillRect(hdc,&rect,hFaceBrush);
		FrameRect(hdc,&rect,hFrameBrush);

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hFaceBrush);
		DeleteObject(hFrameBrush);

		return 0;
	}

	virtual LRESULT onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{
		colCurrent=colBTNFACEDOWN;
		this->repaint();
		return 0;
	}

	virtual LRESULT onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
		colCurrent=colBTNFACE;
		this->repaint();
		return 0;
	}	

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){
			case WM_LBUTTONDOWN:
				return onMLButtonDown(wParam,lParam);
			case WM_LBUTTONUP:
				return onMLButtonUp(wParam,lParam);
			default:
				return this->DWComponent::windowProc( hWnd, msg, wParam, lParam );
		}
		return 0;
	}

};*/

class DWLabel: public DWComponent
{

protected:
	COLORREF colLBLTEXT;
public:
	DWLabel(LPCWSTR compText)
	{
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(80,20);
		this->setPosition(0,0);
		this->setText(compText);

		colLBLTEXT=DWLookAndFeel::COL_LBL_TEXT;

	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HGDIOBJ oldGDIObj;

		hdc = BeginPaint(this->getHWND(), &ps);

		GetClientRect(this->getHWND(), &rect);

		oldGDIObj=SelectObject(hdc,this->getFont()->getFontHandle());
		SetBkMode(hdc,TRANSPARENT); 
		SetTextColor(hdc,colLBLTEXT);
		TextOut(hdc,rect.left,rect.top,this->getText(),lstrlen(this->getText()));
		SelectObject(hdc,oldGDIObj); // restore previous gdi object!

		EndPaint(this->getHWND(),&ps);

		return 0;
	}

	virtual void setText(LPCWSTR compText)
	{
		this->DWComponent::setText(compText);
		this->repaint();
	}

	virtual void setColor(COLORREF txtColor)
	{
		colLBLTEXT=txtColor;
		this->repaint();
	}
};

static void (__stdcall *setLayeredWindowAttributes)(HWND, int, int, int);

class DWRootWindow: public DWComponent
{
protected:
	COLORREF colWNDBACKGROUND;
	COLORREF colWNDBORDER;

public:
	static const int BORDER_WIDTH=1;

	DWRootWindow()
	{
		this->setText(_T("DWRootWindow"));
		this->setSize(400,200);
		this->setStyle(WS_POPUP|WS_CLIPSIBLINGS);
		this->setExStyle(WS_EX_TOOLWINDOW|WS_EX_ACCEPTFILES|WS_EX_CONTROLPARENT);
		this->wc.style=CS_HREDRAW | CS_VREDRAW;

		colWNDBACKGROUND=DWLookAndFeel::COL_WNDBACKGROUND;
		colWNDBORDER=DWLookAndFeel::COL_WNDBORDER;
	}

	virtual int getRealX(int x)
	{
		return x+BORDER_WIDTH;
	}

	virtual int getRealY(int y)
	{
		return y+BORDER_WIDTH;
	}

	virtual int getClientAreaWidth()
	{
		return this->getWidth()-(BORDER_WIDTH*2);
	}

	virtual int getClientAreaHeight()
	{
		return this->getHeight()-(BORDER_WIDTH*2);
	}

	virtual void setColor(COLORREF background,COLORREF border)
	{
		colWNDBACKGROUND=background;
		colWNDBORDER=border;
		this->repaint();
	}

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		UINT uHitTest;

		switch(msg){
			case WM_DESTROY:
				this->onDestroy();
				break;
			case WM_NCHITTEST:
				uHitTest = (UINT)DefWindowProc(hWnd, WM_NCHITTEST, wParam, lParam);
				if(uHitTest == HTCLIENT)
					return HTCAPTION;
				else
					return uHitTest;

			default:
				return this->DWComponent::windowProc(hWnd,msg,wParam,lParam);
		}
		return 0;
	}

	virtual void onDestroy()
	{
		DestroyWindow(getHWND());
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hBKBrush,hBorderBrush;

		hdc = BeginPaint(this->getHWND(), &ps);
		hBKBrush=CreateSolidBrush(colWNDBACKGROUND);
		hBorderBrush=CreateSolidBrush(colWNDBORDER);

		GetClientRect(this->getHWND(), &rect);
		FillRect(hdc,&rect,hBKBrush);
		FrameRect(hdc,&rect,hBorderBrush);

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hBKBrush);
		DeleteObject(hBorderBrush);

		return 0;
	}

	void centerScreen()
	{
		this->setPosition((GetSystemMetrics(SM_CXSCREEN)-compWidth)/2,(GetSystemMetrics(SM_CYSCREEN)-compHeight)/2);
	}

	virtual void setAlpha(int alpha){ // this can be call only after window creation!

		static const int WS_EX_LAYERED=0x80000;

		if(this->getHWND())
		{
			SetWindowLong(this->getHWND(), GWL_EXSTYLE, GetWindowLong(this->getHWND(), GWL_EXSTYLE) & ~WS_EX_LAYERED);
			SetWindowLong(this->getHWND(), GWL_EXSTYLE, GetWindowLong(this->getHWND(), GWL_EXSTYLE) | WS_EX_LAYERED);

			setLayeredWindowAttributes=(void (__stdcall *)(HWND,int,int,int))GetProcAddress(LoadLibrary(_T("USER32.DLL")) ,"SetLayeredWindowAttributes");
			(*setLayeredWindowAttributes)(this->getHWND(), 0, alpha, 2); 
		}
	}

	virtual void setAlwaysOnTop(bool state) // this can be call only if window is visible!
	{
		if(this->getHWND())
		{
			SetWindowPos (this->getHWND(), state?HWND_TOPMOST:HWND_NOTOPMOST,0, 0, 0, 0,SWP_NOMOVE | SWP_NOSIZE );
		}
	}

};



class DWWindow: public DWRootWindow // window with title bar
{
private:
	bool isCursorOnTitleBar()
	{
		POINT cursorPos;
        GetCursorPos(&cursorPos);
        ScreenToClient(compHWND, &cursorPos);
        RECT windowRect;
		GetClientRect(compHWND, &windowRect);

		if( cursorPos.y<=TITLEBAR_HEIGHT)
			return true;
		return false;
	}

protected:
	COLORREF colTITLEBACKGROUND;
	COLORREF colTITLEDABACKGROUND;
	COLORREF colTITLEBAR_CURRENT;
	COLORREF colTITLEBORDER;
	COLORREF colTITLETEXT;

	bool clientAreaDrag;

public:
	static const int TITLEBAR_HEIGHT=20;

	DWWindow()
	{
		this->setText(_T("DWWindow"));
		this->setExStyle(WS_EX_ACCEPTFILES|WS_EX_CONTROLPARENT);

		colTITLEBACKGROUND=DWLookAndFeel::COL_TITLEBAR_BACKGROUND;
		colTITLEBAR_CURRENT=DWLookAndFeel::COL_TITLEBAR_BACKGROUND;
		colTITLEDABACKGROUND=DWLookAndFeel::COL_TITLEBAR_DEACTIVE_BACKGROUND;
		colTITLEBORDER=DWLookAndFeel::COL_TITLEBAR_BORDER;
		colTITLETEXT=DWLookAndFeel::COL_TITLEBAR_TEXT;

		this->compFont->setFontHandle(DWFont::getSystemFontHandle());
		this->clientAreaDrag=false;

	}

	virtual void EnableClientAreaDrag(bool state)
	{
		this->clientAreaDrag=state;
	}

	virtual int getRealX(int x)
	{
		return x+BORDER_WIDTH;
	}

	virtual int getRealY(int y)
	{
		return DWWindow::TITLEBAR_HEIGHT+y;
	}

	virtual int getClientAreaWidth()
	{
		return this->getWidth()-(BORDER_WIDTH*2);
	}

	virtual int getClientAreaHeight()
	{
		return this->getHeight()-(TITLEBAR_HEIGHT+BORDER_WIDTH);
	}

	virtual void setTitleColor(COLORREF background,COLORREF deactiveBackground,COLORREF border,COLORREF text)
	{
		colTITLEBACKGROUND=background;
		colTITLEBAR_CURRENT=background;
		colTITLEDABACKGROUND=deactiveBackground;
		colTITLEBORDER=border;
		colTITLETEXT=text;
		this->repaint();
	}

	virtual void setText(LPCWSTR compText)
	{
		this->DWComponent::setText(compText);
		this->repaint();
	}

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){

			case WM_NCHITTEST:			
				if(clientAreaDrag || isCursorOnTitleBar())
					return this->DWRootWindow::windowProc(hWnd,msg,wParam,lParam); // drag the window!
				return DefWindowProc(hWnd,msg,wParam,lParam);					

			case WM_ACTIVATE:
				if( (LOWORD(wParam)==WA_ACTIVE)||(LOWORD(wParam)==WA_CLICKACTIVE))
				{
					this->onActivate();
				}else
				{
					this->onDeactivate();
				}
				break;
			case WM_CLOSE:
				this->onClose();
				break;
			default:
				return this->DWRootWindow::windowProc(hWnd,msg,wParam,lParam);
		}
		return 0;
	}

	virtual void onClose()
	{
		DestroyWindow(this->getHWND());
	}

	virtual void closeDWWindow()
	{
		PostMessage(this->getHWND(),WM_CLOSE,0,0);
	}

	virtual void minimizeWindow()
	{
		CloseWindow(this->getHWND());
	}

	virtual void onActivate()
	{
		colTITLEBAR_CURRENT=colTITLEBACKGROUND;
		this->repaint();
	}

	virtual void onDeactivate()
	{
		colTITLEBAR_CURRENT=colTITLEDABACKGROUND;
		this->repaint();
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		SIZE txtSize;
		HBRUSH  hBKBrush,hBorderBrush,hTBKBrush,hTBorderBrush;
		HGDIOBJ oldGDIObj;

		hdc = BeginPaint(this->getHWND(), &ps);

		hBKBrush=CreateSolidBrush(colWNDBACKGROUND);
		hBorderBrush=CreateSolidBrush(colWNDBORDER);
		hTBKBrush=CreateSolidBrush(colTITLEBAR_CURRENT);
		hTBorderBrush=CreateSolidBrush(colTITLEBORDER);

		GetClientRect(this->getHWND(), &rect);

		FillRect(hdc,&rect,hBKBrush); // draw window rect!
		FrameRect(hdc,&rect,hBorderBrush);

		rect.bottom=rect.top+TITLEBAR_HEIGHT; 
		FillRect(hdc,&rect,hTBKBrush); // draw title bar!
		FrameRect(hdc,&rect,hTBorderBrush);

		oldGDIObj=SelectObject(hdc,this->getFont()->getFontHandle());
		SetTextColor(hdc,colTITLETEXT);
		SetBkMode(hdc,TRANSPARENT); 
		GetTextExtentPoint32(hdc, this->getText(), lstrlen(this->getText()), &txtSize); // title text is centered!
		TextOut(hdc,(rect.right-txtSize.cx)/2,(rect.bottom-txtSize.cy)/2,this->getText(),lstrlen(this->getText()));
		SelectObject(hdc,oldGDIObj); // restore previous gdi object!

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hBKBrush);
		DeleteObject(hBorderBrush);
		DeleteObject(hTBKBrush);
		DeleteObject(hTBorderBrush);

		return 0;
	}

};

class DWRootButton: public DWComponent
{
public:

	static const int SYSTEM_BUTTON_SIZE=12;

	DWRootButton()
	{
	}

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){
			case WM_LBUTTONDOWN:
				SetCapture(this->getHWND());
				this->onMLButtonDown(wParam,lParam);
				break;
			case WM_LBUTTONUP:
				ReleaseCapture();
				this->onMLButtonUp(wParam,lParam);
				this->onMouseClick(wParam,lParam);
				break;
			default:
				return this->DWComponent::windowProc(hWnd,msg,wParam,lParam);
		}
		return 0;
	}

	virtual void onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{	
	}

	virtual void onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
	}

	virtual void onMouseClick(WPARAM wParam,LPARAM lParam)
	{
	}

};

class DWButtonEventHandler
{
public:
	virtual void onButtonClick(DWRootButton* clickedButton){}
};

class DWButton: public DWRootButton
{
protected:
	COLORREF colBTNBACKGROUND;
	COLORREF colBTNFRAME;
	COLORREF colBTNTEXT;

	bool buttonDownState;
	DWButtonEventHandler* buttonEventHandler;

public:
	DWButton()
	{
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(50,20);
		this->setPosition(0,0);

		colBTNBACKGROUND=DWLookAndFeel::COL_BTNBACKGROUND;
		colBTNFRAME=DWLookAndFeel::COL_BTNFRAME;
		colBTNTEXT=DWLookAndFeel::COL_BTNTEXT;

		buttonDownState=false;
		buttonEventHandler=0;

	}

	virtual void setColor(COLORREF background,COLORREF text,COLORREF border)
	{
		colBTNBACKGROUND=background;
		colBTNFRAME=border;
		colBTNTEXT=text;

		this->repaint();
	}

	virtual void setEventHandler(DWButtonEventHandler* buttonEventHandler)
	{
		this->buttonEventHandler=buttonEventHandler;
	}

	virtual void onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{
		buttonDownState=true;
		this->repaint();
	}

	virtual void onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
		buttonDownState=false;
		this->repaint();
	}

	virtual void onMouseClick(WPARAM wParam,LPARAM lParam)
	{	
		Sleep(100); // give some small time to draw anim...
		if(buttonEventHandler)
			buttonEventHandler->onButtonClick(this);
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hBKBrush,hBorderBrush;
		HGDIOBJ oldGDIObj;
		SIZE txtSize;

		hdc = BeginPaint(compHWND, &ps);

		hBKBrush=CreateSolidBrush(colBTNBACKGROUND);
		hBorderBrush=CreateSolidBrush(colBTNFRAME);

		GetClientRect(compHWND, &rect);

		FillRect(hdc,&rect,hBKBrush);
		FrameRect(hdc,&rect,hBorderBrush);

		oldGDIObj=SelectObject(hdc,this->getFont()->getFontHandle());
		SetBkMode(hdc,TRANSPARENT); 
		SetTextColor(hdc,colBTNTEXT);
		GetTextExtentPoint32(hdc, this->getText(), lstrlen(this->getText()), &txtSize);

		if(buttonDownState)
			TextOut(hdc,((rect.right-txtSize.cx)/2)+1,((rect.bottom-txtSize.cy)/2)+1,this->getText(),lstrlen(this->getText()));
		else
			TextOut(hdc,(rect.right-txtSize.cx)/2,(rect.bottom-txtSize.cy)/2,this->getText(),lstrlen(this->getText()));

		SelectObject(hdc,oldGDIObj); // restore previous gdi object!


		EndPaint(compHWND,&ps);
		DeleteObject(hBKBrush);
		DeleteObject(hBorderBrush);


		return 0;
	}
};

class DWCloseButton: public DWRootButton
{
protected:

	COLORREF colCLOSE_BUTTON_BACKGROUND;
	COLORREF colCLOSE_BUTTON_BOX_DOWN;
	COLORREF colCLOSE_BUTTON_BOX;
	COLORREF colCLOSE_BUTTON_FRAME;

	COLORREF colCURRENT_BOX;

	DWWindow* parent;

public:

	DWCloseButton(DWWindow* parent)
	{
		this->parent=parent;
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(SYSTEM_BUTTON_SIZE,SYSTEM_BUTTON_SIZE);
		this->setPosition((parent->getWidth()-SYSTEM_BUTTON_SIZE)-((DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2),(DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2);
	
		colCLOSE_BUTTON_BACKGROUND=DWLookAndFeel::COL_CLOSE_BUTTON_BACKGROUND;
		colCLOSE_BUTTON_BOX_DOWN=DWLookAndFeel::COL_CLOSE_BUTTON_BOX_DOWN;
		colCLOSE_BUTTON_BOX=DWLookAndFeel::COL_CLOSE_BUTTON_BOX;
		colCLOSE_BUTTON_FRAME=DWLookAndFeel::COL_CLOSE_BUTTON_FRAME;
		
		colCURRENT_BOX=DWLookAndFeel::COL_CLOSE_BUTTON_BOX;

	}

	virtual void setColor(COLORREF background,COLORREF box,COLORREF boxDown,COLORREF frame)
	{
		colCLOSE_BUTTON_BACKGROUND=background;
		colCLOSE_BUTTON_BOX_DOWN=boxDown;
		colCLOSE_BUTTON_BOX=box;
		colCLOSE_BUTTON_FRAME=frame;
		colCURRENT_BOX=box;
		this->repaint();
	}

	virtual void parentResized()
	{
		this->setPosition((parent->getWidth()-SYSTEM_BUTTON_SIZE)-((DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2),(DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2);
	}

	virtual void onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{
		colCURRENT_BOX=colCLOSE_BUTTON_BOX_DOWN;
		this->repaint();
	}

	virtual void onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
		colCURRENT_BOX=colCLOSE_BUTTON_BOX;
		this->repaint();
	}

	virtual void onMouseClick(WPARAM wParam,LPARAM lParam)
	{	
		Sleep(100); // give some small time to draw anim...
		this->parent->closeDWWindow();
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hBKBrush,hBorderBrush,hBoxBrush;

		hdc = BeginPaint(this->getHWND(), &ps);

		hBKBrush=CreateSolidBrush(colCLOSE_BUTTON_BACKGROUND);
		hBorderBrush=CreateSolidBrush(colCLOSE_BUTTON_FRAME);
		hBoxBrush=CreateSolidBrush(colCURRENT_BOX);

		GetClientRect(this->getHWND(), &rect);

		FillRect(hdc,&rect,hBKBrush); // draw close buton rect!
		FrameRect(hdc,&rect,hBorderBrush);
		rect.left=2;
		rect.top=2;
		rect.bottom=SYSTEM_BUTTON_SIZE-2;
		rect.right=SYSTEM_BUTTON_SIZE-2;
		FillRect(hdc,&rect,hBoxBrush); 

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hBKBrush);
		DeleteObject(hBorderBrush);
		DeleteObject(hBoxBrush);

		return 0;
	}

};

class DWMinimizeButton: public DWRootButton
{
protected:

	COLORREF colMIN_BUTTON_BACKGROUND;
	COLORREF colMIN_BUTTON_BACKGROUND_DOWN;
	COLORREF colMIN_BUTTON_BOX;
	COLORREF colMIN_BUTTON_FRAME;

	COLORREF colCURRENT_BACKGROUND;

	DWWindow* parent;

public:

	DWMinimizeButton(DWWindow* parent)
	{
		this->parent=parent;
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(SYSTEM_BUTTON_SIZE,SYSTEM_BUTTON_SIZE);
		this->setPosition((DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2,(DWWindow::TITLEBAR_HEIGHT-SYSTEM_BUTTON_SIZE)/2);
	
		colMIN_BUTTON_BACKGROUND=DWLookAndFeel::COL_MIN_BUTTON_BACKGROUND;
		colMIN_BUTTON_BACKGROUND_DOWN=DWLookAndFeel::COL_MIN_BUTTON_BACKGROUND_DOWN;
		colMIN_BUTTON_BOX=DWLookAndFeel::COL_MIN_BUTTON_BOX;
		colMIN_BUTTON_FRAME=DWLookAndFeel::COL_MIN_BUTTON_FRAME;
		
		colCURRENT_BACKGROUND=DWLookAndFeel::COL_MIN_BUTTON_BACKGROUND;

	}

	virtual void setColor(COLORREF background,COLORREF downBackground,COLORREF box,COLORREF frame)
	{
		colMIN_BUTTON_BACKGROUND=background;
		colCURRENT_BACKGROUND=background;
		colMIN_BUTTON_BACKGROUND_DOWN=downBackground;
		colMIN_BUTTON_BOX=box;
		colMIN_BUTTON_FRAME=frame;
		this->repaint();

	}

	virtual void onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{
		colCURRENT_BACKGROUND=colMIN_BUTTON_BACKGROUND_DOWN;
		this->repaint();
	}

	virtual void onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
		colCURRENT_BACKGROUND=colMIN_BUTTON_BACKGROUND;
		this->repaint();
	}

	virtual void onMouseClick(WPARAM wParam,LPARAM lParam)
	{	
		Sleep(100); // give some small time to draw anim...
		this->parent->minimizeWindow();
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{
		
		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hBKBrush,hBorderBrush,hBoxBrush;

		hdc = BeginPaint(this->getHWND(), &ps);

		hBKBrush=CreateSolidBrush(colCURRENT_BACKGROUND);
		hBorderBrush=CreateSolidBrush(colMIN_BUTTON_FRAME);
		hBoxBrush=CreateSolidBrush(colMIN_BUTTON_BOX);

		GetClientRect(this->getHWND(), &rect);

		FillRect(hdc,&rect,hBKBrush); // draw close buton rect!
		FrameRect(hdc,&rect,hBorderBrush);
		rect.left=2;
		rect.top=(SYSTEM_BUTTON_SIZE/2)+2;
		rect.bottom=SYSTEM_BUTTON_SIZE-2;
		rect.right=SYSTEM_BUTTON_SIZE-2;
		FillRect(hdc,&rect,hBoxBrush); 

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hBKBrush);
		DeleteObject(hBorderBrush);
		DeleteObject(hBoxBrush);

		return 0;
	}
};

/*
class DWResizeControl: public DWRootButton
{
protected:
	COLORREF colRESIZE_CONTROL;

	DWWindow* parent;

	HRGN hControlRgn;

	bool lButtonDown;

	int clickedX,clickedY;

	POINT clickedPoint;

public:

	static const int RESIZE_CONTROL_SIZE=10;

	DWResizeControl(DWWindow* parent)
	{
		this->parent=parent;
		this->setStyle(this->getStyle()|WS_CHILD);
		this->setSize(RESIZE_CONTROL_SIZE,RESIZE_CONTROL_SIZE);
		this->setPosition(parent->getWidth()-RESIZE_CONTROL_SIZE,parent->getHeight()-RESIZE_CONTROL_SIZE);

		this->wc.hCursor=LoadCursor(NULL,IDC_SIZENWSE);

		colRESIZE_CONTROL=DWLookAndFeel::COL_RESIZE_CONTROL;

		lButtonDown=false;
	}

	~DWResizeControl()
	{
		DeleteObject(hControlRgn);
	} 

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){
			case WM_MOUSEMOVE:			
				this->onMouseMove(wParam,lParam);
				break;
			default:
				return this->DWRootButton::windowProc(hWnd,msg,wParam,lParam);
		}
		return 0;
	}

	virtual void onMouseMove(WPARAM wParam,LPARAM lParam)
	{
		if(lButtonDown)
		{
			int xPos = (signed int)LOWORD(lParam);
			int yPos = (signed int)HIWORD(lParam);

			int widthIncrement=(xPos-clickedX);
			int heightIncrement=(yPos-clickedY);

			int parentWidth=parent->getWidth();
			int parentHeight=parent->getHeight();

			//if(widthIncrement>5)
				parentWidth=parentWidth+widthIncrement;

			//if(heightIncrement>5)
				parentHeight=parentHeight+heightIncrement;

			//if(widthIncrement>100)
				//return;
			//if(heightIncrement>100)
				//return;

			//this->setPosition(parentWidth-RESIZE_CONTROL_SIZE,parentHeight-RESIZE_CONTROL_SIZE);
			parent->setSize(parentWidth,parentHeight);
								
		}
	}

	virtual void onMLButtonDown(WPARAM wParam,LPARAM lParam)
	{
		clickedX= (signed int)LOWORD(lParam);
		clickedY= (signed int)HIWORD(lParam);

		GetCursorPos(&clickedPoint);

		lButtonDown=true;

	}

	virtual void onMLButtonUp(WPARAM wParam,LPARAM lParam)
	{
		lButtonDown=false;
	}

	virtual void setColor(COLORREF background)
	{
		colRESIZE_CONTROL=background;
		this->repaint();
	}

	virtual void parentResized()
	{
		this->setPosition(parent->getWidth()-RESIZE_CONTROL_SIZE,parent->getHeight()-RESIZE_CONTROL_SIZE);
	}

	virtual bool createComponent()
	{
		if(this->DWRootButton::createComponent())
		{
			POINT points[3];
			points[0].x=0;
			points[0].y=RESIZE_CONTROL_SIZE;
			points[1].x=RESIZE_CONTROL_SIZE;
			points[1].y=0;
			points[2].x=RESIZE_CONTROL_SIZE;
			points[2].y=RESIZE_CONTROL_SIZE;
			hControlRgn=CreatePolygonRgn(points,3,WINDING);;
			SetWindowRgn(this->getHWND(),hControlRgn,TRUE);
		}
		return false;
	}

	virtual LRESULT onPaint(WPARAM wParam,LPARAM lParam)
	{

		HDC hdc;
		PAINTSTRUCT ps;
		RECT rect;
		HBRUSH  hBKBrush;

		hdc = BeginPaint(this->getHWND(), &ps);

		hBKBrush=CreateSolidBrush(colRESIZE_CONTROL);

		GetClientRect(this->getHWND(), &rect);

		FillRect(hdc,&rect,hBKBrush);

		EndPaint(this->getHWND(),&ps);
		DeleteObject(hBKBrush);

		return 0;
	}
};
*/

class DWAppWindow: public DWWindow
{
private:
	bool isCursorOnResizeBorder()
	{
		POINT cursorPos;
        GetCursorPos(&cursorPos);
        ScreenToClient(compHWND, &cursorPos);
        RECT windowRect;
		GetClientRect(compHWND, &windowRect);

		if( (cursorPos.x>=windowRect.right-(SIZER_WIDTH*2)) && (cursorPos.y>=windowRect.bottom-(SIZER_WIDTH*2)) )
			return true;
		else if(cursorPos.x>=windowRect.right-SIZER_WIDTH)
			return true;
		else if(cursorPos.y>=windowRect.bottom-SIZER_WIDTH)
			return true;
		else
			return false;
		
	}

protected:
	DWCloseButton* closeButton;
	DWMinimizeButton* minimizeButton;

	bool resizable;
	bool resizing;
	RECT mDownWndRectForResize;
	int clickedXPosForResize,clickedYPosForResize;
	int sizingType;
	int minWidth,minHeight,maxWidth,maxHeight;

public:
	static const int SIZER_WIDTH=3;

	DWAppWindow(bool minButton,bool resizable)
	{
		this->resizable=resizable;

		minWidth=150;
		minHeight=150;
		maxWidth=800;
		maxHeight=600;
		minimizeButton=0;
		resizing=false;

		if(minButton)
		{
			this->setStyle(this->getStyle()|WS_MINIMIZEBOX);
			minimizeButton=new DWMinimizeButton(this);
		}

		closeButton=new DWCloseButton(this);

		this->setStyle(this->getStyle()|WS_SYSMENU);		
		this->setText(_T("DWAppWindow"));

	}

	virtual void setMinSize(int minWidth,int minHeight)
	{
		this->minWidth=minWidth;
		this->minHeight=minHeight;
	}

	virtual void setMaxSize(int maxWidth,int maxHeight)
	{
		this->maxWidth=maxWidth;
		this->maxHeight=maxHeight;
	}

	virtual LRESULT windowProc(HWND hWnd, UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg){

			case WM_NCHITTEST:			
				if(isCursorOnResizeBorder())
				{
					return DefWindowProc(hWnd,msg,wParam,lParam);
				}
				else
					return this->DWWindow::windowProc(hWnd,msg,wParam,lParam); // otherwise drag the window!

			case WM_LBUTTONDOWN:
				if(resizable)
				{
					if(this->onMLButtonDownForResize(wParam,lParam))
						return 0; // left button down on border!
				}
				return this->DWWindow::windowProc(hWnd,msg,wParam,lParam);// left button down on client area!

			case WM_MOUSEMOVE:
				if(resizable)
				{
					if(resizing)
					{
						this->onMouseMoveForResize(wParam,lParam);
						return 0;
					}
				}
				return this->DWWindow::windowProc(hWnd,msg,wParam,lParam);

			case WM_LBUTTONUP:
				if(resizable)
				{
					if(resizing)
					{
						this->onMLButtonUpForResize(wParam,lParam);
						return 0;
					}
				}
				return this->DWWindow::windowProc(hWnd,msg,wParam,lParam);

			case WM_SETCURSOR:	
				if(resizable)
				{
					this->onSetCursorForResize(wParam,lParam);
					return 0;
				}
				return this->DWWindow::windowProc(hWnd,msg,wParam,lParam);

			default:
				return this->DWWindow::windowProc(hWnd,msg,wParam,lParam);
		}
		return 0;
	}

	virtual void onMLButtonUpForResize(WPARAM wParam,LPARAM lParam)
	{
		resizing=false;
		ReleaseCapture();
	}

	virtual void onMouseMoveForResize(WPARAM wParam,LPARAM lParam)
	{

		POINT cursorPos;
		GetCursorPos(&cursorPos);//screen coords
		ScreenToClient(compHWND, &cursorPos);

		int originalWidth = mDownWndRectForResize.right - mDownWndRectForResize.left;
		int originalHeight = mDownWndRectForResize.bottom - mDownWndRectForResize.top;
		int newWidth= originalWidth + (cursorPos.x-clickedXPosForResize);
		int newHeight = originalHeight + (cursorPos.y-clickedYPosForResize);

		if( (minWidth>newWidth) || (newWidth>maxWidth) )
			newWidth=compWidth;

		if( (minHeight>newHeight) || (newHeight>maxHeight) )
			newHeight=compHeight;

		if(sizingType==0)
			SetWindowPos(compHWND, NULL, 0, 0, newWidth,newHeight, SWP_NOMOVE | SWP_NOZORDER);
		else if(sizingType==1)
			SetWindowPos(compHWND, NULL, 0, 0, newWidth,compHeight, SWP_NOMOVE | SWP_NOZORDER);
		else if(sizingType==2)
			SetWindowPos(compHWND, NULL, 0, 0, compWidth, newHeight, SWP_NOMOVE | SWP_NOZORDER);
		
  }

	virtual bool onMLButtonDownForResize(WPARAM wParam,LPARAM lParam)
	{		
		clickedXPosForResize = LOWORD(lParam);  // horizontal position of cursor 
		clickedYPosForResize = HIWORD(lParam);  // vertical position of cursor

		GetWindowRect(this->getHWND(), &mDownWndRectForResize);

		POINT right_p = { mDownWndRectForResize.right, 0 };
		ScreenToClient(this->getHWND(), &right_p);
		POINT down_p = { 0, mDownWndRectForResize.bottom };
		ScreenToClient(this->getHWND(), &down_p);

		if( (clickedXPosForResize >= right_p.x - (SIZER_WIDTH*2)) && (clickedYPosForResize >= down_p.y - (SIZER_WIDTH*2)) )
		{
			SetCapture(this->getHWND());
			resizing=true;
			sizingType=0;// both sizing...
			return true;
		}
		else if (clickedXPosForResize >= right_p.x - SIZER_WIDTH)
		{
			SetCapture(this->getHWND());
			resizing=true;
			sizingType=1;// width sizing...
			return true;
		}else if(clickedYPosForResize >= down_p.y - SIZER_WIDTH)
		{
			SetCapture(this->getHWND());
			resizing=true;
			sizingType=2;// height sizing...
			return true;
		}

		return false;
 
	}

	virtual void onSetCursorForResize(WPARAM wParam,LPARAM lParam)
	{
		POINT cursorPos;
        GetCursorPos(&cursorPos);
        ScreenToClient(this->getHWND(), &cursorPos);
        RECT windowRect;
		GetClientRect(this->getHWND(), &windowRect);

		if( (cursorPos.x>=windowRect.right-(SIZER_WIDTH*2)) && (cursorPos.y>=windowRect.bottom-(SIZER_WIDTH*2)) )
			SetCursor(LoadCursor(NULL, IDC_SIZENWSE));
		else if(cursorPos.x>=windowRect.right-SIZER_WIDTH)
			SetCursor(LoadCursor(NULL, IDC_SIZEWE));
		else if( (cursorPos.y<compHeight) & (cursorPos.y>=windowRect.bottom-SIZER_WIDTH)) // we check (cursorPos.y<compHeight), otherwise sysmenu cursor will be IDC_SIZENS
			SetCursor(LoadCursor(NULL, IDC_SIZENS));
		else
			SetCursor(LoadCursor(NULL, IDC_ARROW));
	}

	virtual bool createComponent()
	{
		if(this->DWWindow::createComponent())
		{
			closeButton->setParentHWND(this->getHWND());

			if(minimizeButton)
				minimizeButton->setParentHWND(this->getHWND());

			if(closeButton->createComponent())
			{
				if(minimizeButton)
					return minimizeButton->createComponent();
				return false;
			}
			return false;
		}
		return false;
	}

	virtual void setSize(int compWidth,int compHeight)
	{
		this->DWWindow::setSize(compWidth,compHeight);

		if(this->getHWND()==0)
		{
			closeButton->parentResized();
		}
	}

	virtual  LRESULT onResize(WPARAM wParam,LPARAM lParam)
	{
		this->DWWindow::onResize(wParam,lParam);
		closeButton->parentResized();
		this->repaint();
		return 0;
	}

	virtual void onDestroy()
	{
		DestroyWindow(this->getHWND());
		PostQuitMessage(0);
	}

	~DWAppWindow()
	{
		if(minimizeButton)
			delete minimizeButton;
		if(closeButton)
			delete closeButton;
	}
};


//=============== user code ========================================

class MyWindow: public DWAppWindow,public DWButtonEventHandler
{

public:
	DWLabel* lbl;
	DWButton *button,*button2;

	MyWindow():DWAppWindow(true,true)
	{

		this->centerScreen();
		this->createComponent();

		lbl=new DWLabel(_T("This is a label"));
		button=new DWButton();
		button2=new DWButton();

		lbl->setPosition(this->getRealX(50),this->getRealY(50));
		lbl->setParentHWND(this->getHWND());
		lbl->createComponent();

		button->setPosition(this->getRealX(100),this->getRealY(100));
		button->setText(L"OK");
		button->setParentHWND(this->getHWND());
		button->createComponent();
		button->setEventHandler(this);

		button2->setPosition(this->getRealX(160),this->getRealY(100));
		button2->setText(L"Message");
		button2->setParentHWND(this->getHWND());
		button2->createComponent();
		button2->setEventHandler(this);

		this->setText(L"Wasabi");

	}

	virtual void onButtonClick(DWRootButton *clickedButton)
	{
		if(clickedButton==button)
			this->closeDWWindow();
		if(clickedButton==button2)
			MessageBox(this->getHWND(),L"Message",L"Info",0);
	}
	
	~MyWindow()
	{
		delete lbl;
		delete button;
		delete button2;
	}

};

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{

	DWApplication::InitDWApp(hInstance);
	
	MyWindow* dw=new MyWindow();

	DWApplication::doMessagePump();

	delete dw;

	return 0;
}