﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Threading;
using System.Collections;
using Manoli.Utils.CSharpFormat;
using System.Diagnostics;

namespace CSharpToCHM
{
    public partial class Form1 : Form
    {
        string projectPath;
        string projectName;
        string outputFile;
        string hhcPath;
        bool recursiveScan;
        bool ignoreDesignerFiles;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox4.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.Filter = "Compiled HTML Help (*.CHM)|*.chm";
            saveFileDialog1.FilterIndex = 0;

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox3.Text = saveFileDialog1.FileName;
            } 
        }

        void generateHtmlFile(string inputFilePath, string outputFilePath)
        {
            CSharpFormat cs = new CSharpFormat();
            string output = cs.FormatCode(File.ReadAllText(inputFilePath));
            string header = "<html><head><link rel=\"stylesheet\" href=\"csharp.css\" type=\"text/css\" /></head><body>";
            string footer = "</body></html>";

            File.WriteAllText(outputFilePath, header + output + footer);
        }

        void generateCSSFile(string outputFilePath)
        {
            string code = ".csharpcode, .csharpcode pre { font-size: small; color: black; font-family: Consolas, \"Courier New\", Courier, Monospace; background-color: #ffffff; }" +
                ".csharpcode pre { margin: 0em; } .csharpcode .rem { color: #008000; } .csharpcode .kwrd { color: #0000ff; } .csharpcode .str { color: #006080; } .csharpcode .op { color: #0000c0; } " +
                ".csharpcode .preproc { color: #cc6633; } .csharpcode .asp { background-color: #ffff00; } .csharpcode .html { color: #800000; } .csharpcode .attr { color: #ff0000; } " +
                " .csharpcode .alt { background-color: #f4f4f4; width: 100%; margin: 0em; } .csharpcode .lnum { color: #606060; }";

            File.WriteAllText(outputFilePath, code);

        }

        void generateHomeHtml(string outputFilePath)
        {
            string code = "<html><body><br><br><br><br><div align=\"center\"><img src=\"logo.png\"></div><h1 align=\"center\">Source Code Listing Of " +
                projectName + " </h1><p align=\"center\"><small>Generated Using CSharpToCHM v1.0</small></p></body></html>";

            File.WriteAllText(outputFilePath, code);
        }

        void generateHhpFile(string outputFilePath,int fileCount)
        {
            string fileList="";
            for(int i=0;i<fileCount;i++)
            {
                fileList=fileList+i+".htm\r\n";
            }

            string code = "[OPTIONS]\r\nCompatibility=1.1 or later\r\nCompiled file=output.chm\r\nContents file=contents.hhc\r\nDefault Window=main\r\n" +
                "Default topic=home.htm\r\nDisplay compile progress=No\r\nFull-text search=Yes\r\nLanguage=0x409 English (United States)\r\nTitle="+projectName+" - Source Code Listing\r\n" +
                "\r\n[WINDOWS]\r\nmain=,\"contents.hhc\",,\"home.htm\",,,,,,0x42520,,0x10382e,[0,0,800,600],,,,,,,0\r\n\r\n" +
                "[FILES]\r\nhome.htm\r\n" + fileList + "\r\n[INFOTYPES]\r\n";

            File.WriteAllText(outputFilePath, code);
        }

        void generateHhcFile(string outputFilePath, ArrayList fileNameList)
        {
            string fileList = "";
            for (int i = 0; i < fileNameList.Count; i++)
            {
                fileList = fileList + "<LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + fileNameList[i] + "\"><param name=\"Local\" value=\"" + i + ".htm\"></OBJECT>\r\n";
            }

            string code = "<!DOCTYPE HTML PUBLIC \" -//IETF//DTD HTML//EN\">\r\n<HTML><HEAD><meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">\r\n<!-- Sitemap 1.0 -->\r\n</HEAD><BODY><OBJECT type=\"text/site properties\"><param name=\"ImageType\" value=\"Folder\"></OBJECT>\r\n" +
                "<UL><LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + projectName + "\"><param name=\"Local\" value=\"home.htm\"></OBJECT><UL>\r\n" + fileList + "\r\n</UL></UL></BODY></HTML>";

            File.WriteAllText(outputFilePath, code);
        }

        void generateChmFile(string currentDir)
        {
            Process p = new Process();

            p.StartInfo.UseShellExecute = false;
            p.StartInfo.RedirectStandardOutput = true;
            p.StartInfo.FileName = hhcPath;
            p.StartInfo.WorkingDirectory = currentDir;
            p.StartInfo.Arguments = "out.hhp";
            p.StartInfo.CreateNoWindow = true;
            p.Start();

            string output = p.StandardOutput.ReadToEnd();
            p.WaitForExit();

            addtoLog(output);
        }

        void Start()
        {
            try
            {
                addtoLog("flushing tmp dir...");

                // flush tmp dir in current folder
                string currentDir = AppDomain.CurrentDomain.BaseDirectory;
                string tmpDir = currentDir + "tmp\\";
                Directory.CreateDirectory(tmpDir);
                Directory.Delete(tmpDir,true);
                Directory.CreateDirectory(tmpDir);

                // iterate over project dir
                DirectoryInfo projectDirInfo = new DirectoryInfo(projectPath);

                ArrayList fileNameList = new ArrayList();

                foreach (FileInfo fileInfo in projectDirInfo.GetFiles())
                {
                    if (fileInfo.Extension == ".cs")
                    {
                        bool ignore = false;
                        if (ignoreDesignerFiles)
                        {
                            if(fileInfo.FullName.Contains("Designer.cs"))
                            {
                                ignore = true;
                            }
                        }

                        if (!ignore)
                        {
                            addtoLog("reading " + fileInfo.Name);
                            addtoLog("generating html file");
                            generateHtmlFile(fileInfo.FullName, tmpDir + fileNameList.Count+".htm");
                            fileNameList.Add(fileInfo.Name);

                        }

                    }
                }

                if(fileNameList.Count!=0)
                {
                    // generate home.htm and csharp.css files
                    addtoLog("generating home html file");
                    generateHomeHtml(tmpDir + "home.htm");
                    addtoLog("generating css file");
                    generateCSSFile(tmpDir+"csharp.css");

                    // copy logo image
                    addtoLog("copying logo image");
                    File.Copy(currentDir + "logo.png", tmpDir + "\\logo.png");

                    // generate hhp and hhc files
                    addtoLog("generating hhp file");
                    generateHhpFile(tmpDir + "\\out.hhp", fileNameList.Count);
                    addtoLog("generating hhc file");
                    generateHhcFile(tmpDir + "\\contents.hhc", fileNameList);

                    // generate chm
                    generateChmFile(tmpDir);

                    // copy chm as output file 
                    if(File.Exists(tmpDir+"\\output.chm"))
                    {
                        if (File.Exists(outputFile))
                            File.Delete(outputFile);

                        File.Copy(tmpDir + "\\output.chm", outputFile);
                        this.Invoke((MethodInvoker)delegate
                        {
                            MessageBox.Show(null, "CHM file sucessfully generated!", "Sucess", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        });
                    }else
                    {
                        MessageBox.Show(null, "CHM file generation failed!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }else
                {
                    MessageBox.Show(null, "Selected project folder does not contains any file!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }catch(Exception ex)
            {
                MessageBox.Show(null, "Exception occured while generating CHM file!\n\nDetails: "+ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            // enable generate button
            this.Invoke((MethodInvoker)delegate
            {
                button4.Enabled = true; // runs on UI thread
            });
            
        }

        void addtoLog(string msg)
        {
            this.Invoke((MethodInvoker)delegate
            {
                textBox5.AppendText(msg+"\n");
            });
        }

        private void button4_Click(object sender, EventArgs e)
        {
            projectPath = textBox1.Text;
            if(projectPath.Length!=0)
            {
                projectName = textBox2.Text.Trim();
                if (projectName.Length != 0)
                {
                    outputFile = textBox3.Text.Trim();
                    if (outputFile.Length != 0)
                    {
                        string hhcDir = textBox4.Text.Trim();
                        if (hhcDir.Length != 0)
                        {
                            hhcPath = hhcDir + "\\hhc.exe";
                            if (File.Exists(hhcPath))
                            {
                                recursiveScan=checkBox1.Checked;
                                ignoreDesignerFiles = checkBox2.Checked;

                                button4.Enabled = false;
                                textBox5.Clear();

                                new Thread(new ThreadStart(Start)).Start();
                            }
                            else
                            {
                                MessageBox.Show(this, "hhc.exe directory is invalid!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show(this, "hhc.exe directory is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show(this, "Output file is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show(this, "Project name is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }else
            {
                MessageBox.Show(this, "Project directory is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            MessageBox.Show(this, "CSharpToCHM v1.0\nBy CrownSoft\n\nhttp://www.crownsoft.net", "About", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }
    }
}
