using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Threading;
using System.Collections;
using Manoli.Utils.CSharpFormat;
using System.Diagnostics;

namespace CSharpToCHM
{
    public partial class Form1 : Form
    {
        string projectPath;
        string projectName;
        string outputFile;
        string hhcPath;
        bool ignoreDesignerFiles;
        bool useLineNumbers;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox4.Text = folderBrowserDialog1.SelectedPath;

                Properties.Settings.Default["hhcpath"] = textBox4.Text;
                Properties.Settings.Default.Save();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.Filter = "Compiled HTML Help (*.CHM)|*.chm";
            saveFileDialog1.FilterIndex = 0;

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox3.Text = saveFileDialog1.FileName;
            } 
        }

        void generateHtmlFile(string inputFilePath, string outputFilePath)
        {
            CSharpFormat cs = new CSharpFormat();
            cs.LineNumbers = useLineNumbers;
            cs.Alternate = useLineNumbers;
            string output = cs.FormatCode(File.ReadAllText(inputFilePath));
            string header = "<html><head><link rel=\"stylesheet\" href=\"csharp.css\" type=\"text/css\" /></head><body>";
            string footer = "</body></html>";

            File.WriteAllText(outputFilePath, header + output + footer);
        }


        void generateHomeHtml(string outputFilePath)
        {
            string code = "<html><body><br><br><br><br><div align=\"center\"><img src=\"logo.png\"></div><h1 align=\"center\">Source Code Listing Of " +
                projectName + " </h1><p align=\"center\"><small>Generated Using CSharpToCHM v1.0</small></p></body></html>";

            File.WriteAllText(outputFilePath, code);
        }

        void generateHhpFile(string outputFilePath,int fileCount)
        {
            string fileList="";
            for(int i=0;i<fileCount;i++)
            {
                fileList=fileList+i+".htm\r\n";
            }

            string code = "[OPTIONS]\r\nCompatibility=1.1 or later\r\nCompiled file=output.chm\r\nContents file=contents.hhc\r\nDefault Window=main\r\n" +
                "Default topic=home.htm\r\nDisplay compile progress=No\r\nFull-text search=Yes\r\nLanguage=0x409 English (United States)\r\nTitle="+projectName+" - Source Code Listing\r\n" +
                "\r\n[WINDOWS]\r\nmain=,\"contents.hhc\",,\"home.htm\",,,,,,0x42520,,0x10382e,[0,0,800,600],,,,,,,0\r\n\r\n" +
                "[FILES]\r\nhome.htm\r\n" + fileList + "\r\n[INFOTYPES]\r\n";

            File.WriteAllText(outputFilePath, code);
        }

        void generateHhcFile(string outputFilePath, ArrayList fileNameList,ArrayList dirList)
        {
            string fileList = "";
            string prevDir = "\\"; // starts with root

            for (int i = 0; i < fileNameList.Count; i++)
            {
                if (dirList[i].ToString() == prevDir) // same dir (root or whatever)
                {
                    fileList = fileList + "<LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + fileNameList[i] + "\"><param name=\"Local\" value=\"" + i + ".htm\"></OBJECT>\r\n";
                }else // not same dir
                {
                    string[] splittedDirList = dirList[i].ToString().Split('\\');
                    string[] rootArray={""};
                    string[] prevSplittedDirList = prevDir=="\\"?rootArray: prevDir.Split('\\');

                    bool unmatchDirDetected = false;

                    for (int j = 0; j < splittedDirList.Length; j++)
                    {
                        if (j >= prevSplittedDirList.Length)
                        {
                            fileList = fileList + "<LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + splittedDirList[j] + "\"></OBJECT>\r\n<UL>\r\n";
                        }
                        else
                        {
                            if (unmatchDirDetected || (splittedDirList[j] != prevSplittedDirList[j])) // found a new dir
                            {
                                unmatchDirDetected = true;
                                int ulCount = prevSplittedDirList.Length - j;
                                for (int k = 0; k < ulCount; k++)
                                {
                                    fileList = fileList + "</UL>\r\n";
                                }

                                fileList = fileList + "<LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + splittedDirList[j] + "\"></OBJECT>\r\n<UL>\r\n";
                            }
                        }
                    }

                    // add file
                    fileList = fileList + "<LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + fileNameList[i] + "\"><param name=\"Local\" value=\"" + i + ".htm\"></OBJECT>\r\n";

                    prevDir = dirList[i].ToString();

                }
            }

            // return to root dir
            int endUlCount = dirList[dirList.Count - 1].ToString().Split('\\').Length;
            for (int k = 0; k < endUlCount; k++)
            {
                fileList = fileList + "</UL>\r\n";
            }

            string code = "<!DOCTYPE HTML PUBLIC \" -//IETF//DTD HTML//EN\">\r\n<HTML><HEAD><meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">\r\n<!-- Sitemap 1.0 -->\r\n</HEAD><BODY><OBJECT type=\"text/site properties\"><param name=\"ImageType\" value=\"Folder\"></OBJECT>\r\n" +
                "<UL><LI> <OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"" + projectName + "\"><param name=\"Local\" value=\"home.htm\"></OBJECT><UL>\r\n" + fileList + "\r\n</UL></UL></BODY></HTML>";

            File.WriteAllText(outputFilePath, code);
        }

        void generateChmFile(string currentDir)
        {
            Process p = new Process();

            p.StartInfo.UseShellExecute = false;
            p.StartInfo.RedirectStandardOutput = true;
            p.StartInfo.FileName = hhcPath;
            p.StartInfo.WorkingDirectory = currentDir;
            p.StartInfo.Arguments = "out.hhp";
            p.StartInfo.CreateNoWindow = true;
            p.Start();

            string output = p.StandardOutput.ReadToEnd();
            p.WaitForExit();

            addtoLog(output);
        }

        void Start()
        {
            try
            {
                addtoLog("creating tmp dir...");

                // flush tmp dir in current folder
                string currentDir = AppDomain.CurrentDomain.BaseDirectory;
                string tmpDir = currentDir + "tmp\\";
                Directory.CreateDirectory(tmpDir);
                Directory.Delete(tmpDir,true);
                Directory.CreateDirectory(tmpDir);

                // ignore list
                string[] ignoreList=null;
                if (ignoreDesignerFiles)
                {
                    ignoreList=File.ReadAllLines(currentDir + "ignore.txt");

                    for (int j = 0; j < ignoreList.Length;j++ ) // remove newlines, spaces
                    {
                         ignoreList[j]=ignoreList[j].Trim();
                    }
                }

                string[] files=Directory.GetFiles(projectPath, "*.*", SearchOption.AllDirectories);

                ArrayList fileNameList = new ArrayList();
                ArrayList dirList = new ArrayList();

                for (int i = 0; i < files.Length; i++)
                {
                    FileInfo fi = new FileInfo(files[i]);

                    if (fi.Extension==".cs")
                    {
                        bool ignore = false;
                        if (ignoreDesignerFiles)
                        {
                            for (int j = 0; j < ignoreList.Length;j++ )
                            {
                                if (ignoreList[j].Length != 0)
                                {
                                    string relativeFilePath = fi.FullName.Substring(projectPath.Length); // file path relative to the project path
                                    if (relativeFilePath.Contains(ignoreList[j]))
                                    {
                                        ignore = true;
                                        break;
                                    }
                                }
                            }       
                        }

                        if (!ignore)
                        {
                            addtoLog("reading " + fi.Name);
                            
                            addtoLog("generating html file");
                            generateHtmlFile(files[i], tmpDir + fileNameList.Count + ".htm");

                            fileNameList.Add(fi.Name);

                            if(projectPath==fi.DirectoryName) // root dir
                            {
                                dirList.Add("\\");
                            }else
                            {
                                dirList.Add(fi.DirectoryName.Substring(projectPath.Length));
                                //addtoLog(fi.DirectoryName.Substring(projectPath.Length));
                            }

                        }

                    }
                }

                if(fileNameList.Count!=0)
                {
                    // generate home.htm file
                    addtoLog("generating home html file");
                    generateHomeHtml(tmpDir + "home.htm");

                    addtoLog("copying css file");
                    File.Copy(currentDir + "csharp.css", tmpDir + "\\csharp.css");

                    // copy logo image
                    addtoLog("copying logo image");
                    File.Copy(currentDir + "logo.png", tmpDir + "\\logo.png");

                    // generate hhp and hhc files
                    addtoLog("generating hhp file");
                    generateHhpFile(tmpDir + "\\out.hhp", fileNameList.Count);
                    addtoLog("generating hhc file");
                    generateHhcFile(tmpDir + "\\contents.hhc", fileNameList, dirList);

                    // generate chm
                    generateChmFile(tmpDir);

                    // copy chm as output file 
                    if(File.Exists(tmpDir+"\\output.chm"))
                    {
                        if (File.Exists(outputFile))
                            File.Delete(outputFile);

                        File.Copy(tmpDir + "\\output.chm", outputFile);
                        Directory.Delete(tmpDir, true);
                        this.Invoke((MethodInvoker)delegate
                        {
                            MessageBox.Show(null, "CHM file sucessfully generated!", "Sucess", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        });
                    }else
                    {
                        MessageBox.Show(null, "CHM file generation failed!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    }
                }else
                {
                    MessageBox.Show(null, "Selected project folder does not contains any file!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }catch(Exception ex)
            {
                MessageBox.Show(null, "Exception occured while generating CHM file!\n\nDetails: "+ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            // enable generate button
            this.Invoke((MethodInvoker)delegate
            {
                button4.Enabled = true; // runs on UI thread
            });
            
        }

        void addtoLog(string msg)
        {
            this.Invoke((MethodInvoker)delegate
            {
                textBox5.AppendText(msg+"\n");
            });
        }

        private void button4_Click(object sender, EventArgs e)
        {
            projectPath = textBox1.Text;
            if(projectPath.Length!=0)
            {
                projectName = textBox2.Text.Trim();
                if (projectName.Length != 0)
                {
                    outputFile = textBox3.Text.Trim();
                    if (outputFile.Length != 0)
                    {
                        string hhcDir = textBox4.Text.Trim();
                        if (hhcDir.Length != 0)
                        {
                            hhcPath = hhcDir + "\\hhc.exe";
                            if (File.Exists(hhcPath))
                            {
                                useLineNumbers = checkBox1.Checked;
                                ignoreDesignerFiles = checkBox2.Checked;

                                button4.Enabled = false;
                                textBox5.Clear();

                                new Thread(new ThreadStart(Start)).Start();
                            }
                            else
                            {
                                MessageBox.Show(this, "hhc.exe directory is invalid!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            }
                        }
                        else
                        {
                            MessageBox.Show(this, "hhc.exe directory is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        }
                    }
                    else
                    {
                        MessageBox.Show(this, "Output file is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    }
                }
                else
                {
                    MessageBox.Show(this, "Project name is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }else
            {
                MessageBox.Show(this, "Project directory is empty!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            MessageBox.Show(this, "CSharpToCHM v1.0\nBy CrownSoft\n\nhttp://www.crownsoft.net", "About", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            textBox4.Text = Properties.Settings.Default["hhcpath"].ToString();
        }
    }
}
