
// static rom to store R8 programs.

/*

Example Blink Program:

mov3 04h 00h, 01h	; write 1 into port0
mov3 03h 00h, 00h	; write to delay device
mov3 04h 00h, 00h	; write 0 into port0
mov3 03h 00h, 00h	; write to delay device
jmp1 01h 00h		; jump to start

Assembled Program: (19 bytes)

03 04 00 01
03 03 00 00
03 04 00 00
03 03 00 00
04 01 00

*/


/*
Example Counter Program:

mov3 04h 01h, 01h ; turn on seven segment decoder (we don't need raw access to leds)
START:
mov3 02h 00h, 00h ; write value 0 into ram location 00h (this is our variable)
LOOP:
mov3 03h 00h, 00h ; write to delay device to get delay
mov1 ax, 02h 00h	; read variable value into ax
mov2 04h 00h, ax  ; put value of ax into seven segment
cmp ax, 09h			; compare ax with 9
je 01h 04h			; jump to START if ax equal to 09h
inc ax				; increase ax by one
mov2 02h 00h, ax  ; write value of ax into ram variable
jmp1 01h 08h			; jump to LOOP

Assembled Program: (30 bytes)

03 04 01 01
03 02 00 00
03 03 00 00
01 02 00
02 04 00
06 09
07 01 04
05
02 02 00
04 01 08

*/

module R8Flash (
	input en, 
	input [4:0] addressBus, 
	input oe, 
	inout [7:0] databus, 
	output busy
);

assign busy = 1'b0;

wire [7:0] flashROM [0:31];

assign flashROM[0]  	= 8'h03;
assign flashROM[1]  	= 8'h04;
assign flashROM[2]  	= 8'h01;
assign flashROM[3]  	= 8'h01;
assign flashROM[4]  	= 8'h03;
assign flashROM[5]  	= 8'h02;
assign flashROM[6]  	= 8'h00;
assign flashROM[7]  	= 8'h00;
assign flashROM[8]  	= 8'h03;
assign flashROM[9]  	= 8'h03;
assign flashROM[10] 	= 8'h00;
assign flashROM[11]  = 8'h00;
assign flashROM[12]  = 8'h01;
assign flashROM[13]  = 8'h02;
assign flashROM[14]  = 8'h00;
assign flashROM[15]  = 8'h02;
assign flashROM[16]  = 8'h04;
assign flashROM[17]  = 8'h00;
assign flashROM[18]  = 8'h06;
assign flashROM[19]  = 8'h0f;
assign flashROM[20] 	= 8'h07;
assign flashROM[21]  = 8'h01;
assign flashROM[22]  = 8'h04;
assign flashROM[23]  = 8'h05;
assign flashROM[24]  = 8'h02;
assign flashROM[25]  = 8'h02;
assign flashROM[26]  = 8'h00;
assign flashROM[27]  = 8'h04;
assign flashROM[28]  = 8'h01;
assign flashROM[29]  = 8'h08;
assign flashROM[30] 	= 8'h00;
assign flashROM[31] 	= 8'h00;

assign databus = (en & oe) ? flashROM[addressBus] : 8'bZZZZZZZZ;

endmodule


/* Blink
assign flashROM[0]  	= 8'h03;
assign flashROM[1]  	= 8'h04;
assign flashROM[2]  	= 8'h00;
assign flashROM[3]  	= 8'h01;
assign flashROM[4]  	= 8'h03;
assign flashROM[5]  	= 8'h03;
assign flashROM[6]  	= 8'h00;
assign flashROM[7]  	= 8'h00;
assign flashROM[8]  	= 8'h03;
assign flashROM[9]  	= 8'h04;
assign flashROM[10] 	= 8'h00;
assign flashROM[11]  = 8'h00;
assign flashROM[12]  = 8'h03;
assign flashROM[13]  = 8'h03;
assign flashROM[14]  = 8'h00;
assign flashROM[15]  = 8'h00;
assign flashROM[16]  = 8'h04;
assign flashROM[17]  = 8'h01;
assign flashROM[18]  = 8'h00;
assign flashROM[19]  = 8'h00;
assign flashROM[20] 	= 8'h00;
assign flashROM[21]  = 8'h00;
assign flashROM[22]  = 8'h00;
assign flashROM[23]  = 8'h00;
assign flashROM[24]  = 8'h00;
assign flashROM[25]  = 8'h00;
assign flashROM[26]  = 8'h00;
assign flashROM[27]  = 8'h00;
assign flashROM[28]  = 8'h00;
assign flashROM[29]  = 8'h00;
assign flashROM[30] 	= 8'h00;
assign flashROM[31] 	= 8'h00;
*/
