
// set address xxx 00000001 value as 1 to enable decoder
// otherwise write to address xxx 00000000 to directly control leds
// (xxx is device address)

module R8SevenSegment (
	
	input reset,
	input wr, 
	input en,
	input hlt_indicate,
	input [7:0] addrbus,
	inout [7:0] databus,
	output busy,
	
	output 	DS_A,DS_B,DS_C,DS_D,DS_E,DS_F,DS_G,
	output	DS_DP, // dot
	input 	clk
);

assign busy = 1'b0;

wire[7:0] leds;
assign {DS_DP,DS_G,DS_F,DS_E,DS_D,DS_C,DS_B,DS_A} = leds ;

reg [7:0] r_leds = 8'd0;
assign leds = hlt_indicate ? 8'b01110110 : r_leds;

reg enableDecoder = 1'b0;

wire [7:0] segmentROM [0:15];
//									.gfedcba
assign segmentROM[0]  = 8'b00111111; // 0
assign segmentROM[1]  = 8'b00000110; // 1
assign segmentROM[2]  = 8'b01011011; // 2
assign segmentROM[3]  = 8'b01001111; // 3
assign segmentROM[4]  = 8'b01100110; // 4
assign segmentROM[5]  = 8'b01101101; // 5
assign segmentROM[6]  = 8'b01111101; // 6
assign segmentROM[7]  = 8'b00000111; // 7
assign segmentROM[8]  = 8'b01111111; // 8
assign segmentROM[9]  = 8'b01101111; // 9
assign segmentROM[10] = 8'b01110111; // a
assign segmentROM[11] = 8'b01111100; // b
assign segmentROM[12] = 8'b01011000; // c
assign segmentROM[13] = 8'b01011110; // d
assign segmentROM[14] = 8'b01111001; // e
assign segmentROM[15] = 8'b01110001; // f

always @ (posedge clk)
begin
	if(en & wr)
	begin
		if(addrbus[0] == 1'b1) // set enableDecoder state
		begin
			enableDecoder <= databus[0];
		end
		else // set decoder output
		begin
			if(enableDecoder)
				r_leds <= segmentROM[databus[3:0]];
			else
				r_leds <= databus;
		end
	end
	else if(reset) 
	begin
		r_leds <= 8'd0;
	end
end

endmodule
