

module R8RAM (

	input [7:0] addrbus, 
	input wr, 
	input en,
	input oe,
	inout [7:0] databus,
	output busy,
	
	input clk
);

reg [7:0] mem [0:255];

assign busy = 1'b0;

assign databus = (en & oe) ? mem[addrbus] : 8'bZZZZZZZZ;

always @(posedge clk)
begin
	if(en & wr)
		mem[addrbus] <= databus;
end

endmodule








