

module R8Delay(input wr, input en, output reg busy, input CLK_48MHZ);

parameter COUNTERBIT = 25;

reg [25:0] counter;
reg startCounting = 1'b0;

always @ (posedge CLK_48MHZ)
begin
	if(wr & en)
	begin
		startCounting <= 1'b1;
		counter <= 26'd0;
		busy <= 1'b1;
	end
	else if(startCounting == 1'b1)
	begin
		counter <= counter + 26'd1;
		if(counter[COUNTERBIT]==1'b1)
		begin
			startCounting <= 1'b0;
			counter <= 26'd0;
			busy <= 1'b0;			
		end
	end
end

endmodule
