
// maximum devices = 8

/*
   Devices				  Address Space
	 Flash				01h 00h - 01h FFh
	 RAM					02h 00h - 02h FFh
	 Delay Device 		03h 00h - 03h FFh
	 LED 					04h 00h - 04h FFh

*/

module MotherBoard(

	output 	DS_A,DS_B,DS_C,DS_D,DS_E,DS_F,DS_G,
	output	DS_EN4,DS_DP,
	input		CLK_48MHZ,
	input [3:0] KEY
);

assign DS_EN4 = 1'b0;

wire hlt;
wire reset;
wire deviceBusy;
wire [7:0] databus;
wire [10:0] addressbus;
wire wr, rd, oe, hlt_indicator;

wire [7:0] devicesEN;
wire SSBusy, delayBusy, flashBusy, ramBusy;
assign deviceBusy = SSBusy | delayBusy | flashBusy | ramBusy;

assign reset = ~KEY[2];
assign hlt = ~KEY[1];

R8CPU cpu( CLK_48MHZ, reset, hlt, deviceBusy, databus, addressbus, wr, rd, oe, hlt_indicator);

AddressDecoder addressDecoder( addressbus[10:8], devicesEN);

R8Flash flash(devicesEN[1], addressbus[5:0], oe, databus, flashBusy);

R8RAM ram(addressbus[7:0], wr, devicesEN[2], oe, databus, ramBusy, CLK_48MHZ);

R8Delay delayDevice(wr, devicesEN[3], delayBusy, CLK_48MHZ);

R8SevenSegment sevenSegment(reset, wr, devicesEN[4], hlt_indicator, addressbus[7:0], databus, SSBusy, DS_A,DS_B,DS_C,DS_D,DS_E,DS_F,DS_G,DS_DP,CLK_48MHZ);

endmodule

